/*
 * Decompiled with CFR 0.152.
 */
package org.yestech.cache.impl;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.terracotta.modules.annotations.AutolockRead;
import org.terracotta.modules.annotations.AutolockWrite;
import org.terracotta.modules.annotations.InstrumentedClass;
import org.terracotta.modules.annotations.Root;
import org.yestech.cache.ICacheManager;
import org.yestech.lib.util.Pair;

@InstrumentedClass
public class ConcurrentMapCacheManager<K, V>
implements ICacheManager<K, V> {
    @Root
    private ConcurrentMap<K, V> cache;

    public ConcurrentMap getCache() {
        return this.cache;
    }

    public void setCache(ConcurrentMap cache) {
        this.cache = cache;
    }

    @Override
    @AutolockRead
    public boolean contains(K k) {
        return this.cache.containsKey(k);
    }

    @Override
    public void putAll(Map<K, V> collection) {
        this.cache.putAll(collection);
    }

    @Override
    @AutolockWrite
    public void put(Pair<K, V> entry) {
        this.put(entry.getFirst(), entry.getSecond());
    }

    @Override
    @AutolockWrite
    public void put(K k, V v) {
        this.cache.putIfAbsent(k, v);
    }

    @Override
    @AutolockRead
    public V get(K key) {
        return this.cache.get(key);
    }

    @Override
    @AutolockWrite
    public void flushAll() {
        this.cache.clear();
    }

    @Override
    @AutolockWrite
    public void flush(K key) {
        this.cache.remove(key);
    }

    @Override
    @AutolockRead
    public Collection<K> keys() {
        return this.cache.keySet();
    }

    @Override
    @AutolockRead
    public Collection<V> values() {
        return this.cache.values();
    }

    @Override
    public void store() {
    }

    @Override
    public void load() {
    }
}

