/*
 * Decompiled with CFR 0.152.
 */
package org.yestech.cache.impl;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;
import org.yestech.cache.ICacheManager;
import org.yestech.lib.util.Pair;

public class EhCacheCacheManager<K, V>
implements ICacheManager<K, V> {
    private static final Logger logger = LoggerFactory.getLogger(EhCacheCacheManager.class);
    private Cache cache;

    public Cache getCache() {
        return this.cache;
    }

    @Required
    public void setCache(Cache cache) {
        this.cache = cache;
    }

    @Override
    public boolean contains(K k) {
        return this.cache.isKeyInCache(k);
    }

    @Override
    public void putAll(Map<K, V> collection) {
        for (Map.Entry<K, V> entry : collection.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void put(Pair<K, V> entry) {
        this.put(entry.getFirst(), entry.getSecond());
    }

    @Override
    public void put(K k, V v) {
        this.cache.put(new Element(k, v));
    }

    @Override
    public V get(K key) {
        long start = System.currentTimeMillis();
        Serializable result = null;
        Element element = this.cache.get(key);
        if (logger.isDebugEnabled()) {
            logger.debug("Time to retrieve from cache: " + (System.currentTimeMillis() - start) + " ms");
        }
        if (element == null || element.getValue() == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Referenced Element: " + element);
                logger.debug("Reference to object associated with cache element [" + key + "] garbage collected");
            }
        } else {
            result = element.getValue();
        }
        return (V)result;
    }

    @Override
    public void flushAll() {
        this.cache.removeAll();
    }

    @Override
    public void flush(K key) {
        this.cache.remove(key);
    }

    @Override
    public Collection<K> keys() {
        return this.cache.getKeys();
    }

    @Override
    public Collection<V> values() {
        return null;
    }

    @Override
    public void store() {
        this.cache.flush();
    }

    @Override
    public void load() {
    }
}

