/*
 * Decompiled with CFR 0.152.
 */
package org.yestech.cache.impl;

import java.util.Collection;
import java.util.Map;
import org.infinispan.Cache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;
import org.yestech.cache.ICacheManager;
import org.yestech.cache.impl.EhCacheCacheManager;
import org.yestech.lib.util.Pair;

public class InfinispanCacheManager<K, V>
implements ICacheManager<K, V> {
    private static final Logger logger = LoggerFactory.getLogger(EhCacheCacheManager.class);
    private Cache cache;

    public Cache getCache() {
        return this.cache;
    }

    @Required
    public void setCache(Cache cache) {
        this.cache = cache;
    }

    @Override
    public boolean contains(K k) {
        return this.cache.containsKey(k);
    }

    @Override
    public void putAll(Map<K, V> collection) {
        for (Map.Entry<K, V> entry : collection.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void put(Pair<K, V> entry) {
        this.put(entry.getFirst(), entry.getSecond());
    }

    @Override
    public void put(K k, V v) {
        this.cache.putIfAbsent(k, v);
    }

    @Override
    public V get(K key) {
        long start = System.currentTimeMillis();
        Object result = this.cache.get(key);
        if (logger.isDebugEnabled()) {
            logger.debug("Time to retrieve from cache: " + (System.currentTimeMillis() - start) + " ms");
        }
        if (result == null) {
            if (logger.isInfoEnabled()) {
                logger.info("Reference to object associated with cache element [" + key + "] garbage collected remove from cache");
            }
            this.flush(key);
        }
        return (V)result;
    }

    @Override
    public void flushAll() {
        this.cache.clear();
    }

    @Override
    public void flush(K key) {
        this.cache.remove(key);
    }

    @Override
    public Collection<K> keys() {
        return this.cache.keySet();
    }

    @Override
    public Collection<V> values() {
        return null;
    }

    @Override
    public void store() {
    }

    @Override
    public void load() {
    }
}

