/*
 * Decompiled with CFR 0.152.
 */
package org.yestech.cache.impl;

import java.util.Collection;
import java.util.Map;
import org.apache.jcs.JCS;
import org.apache.jcs.access.exception.CacheException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;
import org.yestech.cache.ICacheManager;
import org.yestech.lib.util.Pair;

public class JCSCacheManager<K, V>
implements ICacheManager<K, V> {
    private static final Logger logger = LoggerFactory.getLogger(JCSCacheManager.class);
    private JCS cache;

    public JCS getCache() {
        return this.cache;
    }

    @Required
    public void setCache(JCS cache) {
        this.cache = cache;
    }

    @Override
    public V get(K key) {
        long start = System.currentTimeMillis();
        Object cachedValue = this.cache.get(key);
        if (logger.isDebugEnabled()) {
            logger.debug("Time to retrieve from cache: " + (System.currentTimeMillis() - start) + " ms");
        }
        if (cachedValue == null) {
            if (logger.isInfoEnabled()) {
                logger.info("Reference to object associated with cache element [" + key + "] garbage collected remove from cache");
            }
            this.flush(key);
        }
        return (V)cachedValue;
    }

    @Override
    public void flushAll() {
        try {
            this.cache.clear();
        }
        catch (CacheException e) {
            logger.error("error flushing all...", (Throwable)e);
        }
    }

    @Override
    public void flush(K key) {
        try {
            this.cache.remove(key);
        }
        catch (CacheException e) {
            logger.error("error flushing key: " + key, (Throwable)e);
        }
    }

    @Override
    public void putAll(Map<K, V> collection) {
        for (Map.Entry<K, V> entry : collection.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void put(Pair<K, V> entry) {
        this.put(entry.getFirst(), entry.getSecond());
    }

    @Override
    public void put(K k, V v) {
        try {
            this.cache.put(k, v);
        }
        catch (CacheException e) {
            logger.error("error putting entry[" + k + "]: " + v, (Throwable)e);
        }
    }

    @Override
    public boolean contains(K k) {
        return this.cache.get(k) != null;
    }

    @Override
    public Collection<K> keys() {
        throw new UnsupportedOperationException("not yet implemented...");
    }

    @Override
    public Collection<V> values() {
        throw new UnsupportedOperationException("not yet implemented...");
    }

    @Override
    public void store() {
    }

    @Override
    public void load() {
    }
}

