/*
 * Decompiled with CFR 0.152.
 */
package org.yestech.cache.impl;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.terracotta.modules.annotations.AutolockRead;
import org.terracotta.modules.annotations.AutolockWrite;
import org.terracotta.modules.annotations.InstrumentedClass;
import org.terracotta.modules.annotations.Root;
import org.yestech.cache.ICacheManager;
import org.yestech.lib.util.Pair;

@InstrumentedClass
public class MapCacheManager<K, V>
implements ICacheManager<K, V> {
    @Root
    private Map<K, V> cache;
    private ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private Lock readLock = this.rwl.readLock();
    private Lock writeLock = this.rwl.writeLock();

    public Map getCache() {
        return this.cache;
    }

    public void setCache(Map cache) {
        this.cache = cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @AutolockRead
    public boolean contains(K k) {
        this.readLock.lock();
        try {
            boolean bl = this.cache.containsKey(k);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @AutolockWrite
    public void putAll(Map<K, V> collection) {
        this.writeLock.lock();
        try {
            this.cache.putAll(collection);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    @AutolockWrite
    public void put(Pair<K, V> entry) {
        this.put(entry.getFirst(), entry.getSecond());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @AutolockWrite
    public void put(K k, V v) {
        this.writeLock.lock();
        try {
            this.cache.put(k, v);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @AutolockRead
    public V get(K key) {
        this.readLock.lock();
        try {
            V v = this.cache.get(key);
            return v;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @AutolockWrite
    public void flushAll() {
        this.writeLock.lock();
        try {
            this.cache.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @AutolockWrite
    public void flush(K key) {
        this.writeLock.lock();
        try {
            this.cache.remove(key);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<K> keys() {
        this.readLock.lock();
        try {
            Set<K> set = this.cache.keySet();
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<V> values() {
        this.readLock.lock();
        try {
            Collection<V> collection = this.cache.values();
            return collection;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void store() {
    }

    @Override
    public void load() {
    }
}

