/*
 * Decompiled with CFR 0.152.
 */
package org.yestech.cache.impl;

import java.util.Collection;
import java.util.Map;
import net.spy.memcached.MemcachedClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;
import org.yestech.cache.ICacheManager;
import org.yestech.lib.util.Pair;

public class MemcachedSynchronousCacheManager<V>
implements ICacheManager<String, V> {
    private static final Logger logger = LoggerFactory.getLogger(MemcachedSynchronousCacheManager.class);
    private int expireTime;
    private MemcachedClient cache;

    public int getExpireTime() {
        return this.expireTime;
    }

    @Required
    public void setExpireTime(int expireTime) {
        this.expireTime = expireTime;
    }

    public MemcachedClient getCache() {
        return this.cache;
    }

    @Required
    public void setCache(MemcachedClient cache) {
        this.cache = cache;
    }

    @Override
    public boolean contains(String k) {
        return this.cache.get(k) != null;
    }

    @Override
    public void putAll(Map<String, V> collection) {
        for (Map.Entry<String, V> entry : collection.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void put(Pair<String, V> entry) {
        this.put((String)entry.getFirst(), entry.getSecond());
    }

    @Override
    public void put(String k, V v) {
        this.cache.add(k, this.expireTime, v);
    }

    @Override
    public V get(String key) {
        long start = System.currentTimeMillis();
        Object result = this.cache.get(key);
        if (logger.isDebugEnabled()) {
            logger.debug("Time to retrieve from cache: " + (System.currentTimeMillis() - start) + " ms");
        }
        if (result == null) {
            if (logger.isInfoEnabled()) {
                logger.info("Reference to object associated with cache element [" + key + "] garbage collected remove from cache");
            }
            this.flush(key);
        }
        return (V)result;
    }

    @Override
    public void flushAll() {
        this.cache.flush();
    }

    @Override
    public void flush(String key) {
        this.cache.delete(key);
    }

    @Override
    public Collection<String> keys() {
        throw new UnsupportedOperationException("Not available");
    }

    @Override
    public Collection<V> values() {
        throw new UnsupportedOperationException("Not available");
    }

    @Override
    public void store() {
    }

    @Override
    public void load() {
    }
}

