/*
 * Decompiled with CFR 0.152.
 */
package org.yestech.cache.impl;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;
import org.tc.cache.CacheException;
import org.tc.cache.ITerracottaCache;
import org.terracotta.modules.annotations.InstrumentedClass;
import org.terracotta.modules.annotations.Root;
import org.yestech.cache.ICacheManager;
import org.yestech.lib.util.Pair;

@InstrumentedClass
public class TerracottaCacheManager<K, V>
implements ICacheManager<K, V> {
    private static final Logger logger = LoggerFactory.getLogger(TerracottaCacheManager.class);
    private String fqn;
    @Root
    private ITerracottaCache cache;

    public ITerracottaCache getCache() {
        return this.cache;
    }

    public String getFqn() {
        return this.fqn;
    }

    @Required
    public void setFqn(String fqn) {
        this.fqn = fqn;
    }

    @Required
    public void setCache(ITerracottaCache cache) {
        this.cache = cache;
    }

    @Override
    public boolean contains(K k) {
        try {
            return this.cache.exists(this.fqn, k);
        }
        catch (CacheException e) {
            return false;
        }
    }

    @Override
    public void putAll(Map<K, V> collection) {
        for (Map.Entry<K, V> entry : collection.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void put(Pair<K, V> entry) {
        this.put(entry.getFirst(), entry.getSecond());
    }

    @Override
    public void put(K k, V v) {
        try {
            this.cache.put(this.fqn, k, v);
        }
        catch (CacheException e) {
            logger.error("error putting entry[" + k + "]: " + v, (Throwable)e);
        }
    }

    @Override
    public V get(K key) {
        long start = System.currentTimeMillis();
        Object cachedValue = null;
        try {
            cachedValue = this.cache.get(this.fqn, key);
        }
        catch (CacheException e) {
            logger.error("error getting key: " + key, (Throwable)e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Time to retrieve from cache: " + (System.currentTimeMillis() - start) + " ms");
        }
        if (cachedValue == null) {
            if (logger.isInfoEnabled()) {
                logger.info("Reference to object associated with cache element [" + key + "] garbage collected remove from cache");
            }
            this.flush(key);
        }
        return (V)cachedValue;
    }

    @Override
    public void flushAll() {
        try {
            this.cache.remove(this.cache.getFqn());
        }
        catch (CacheException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void flush(K key) {
        try {
            this.cache.remove(this.fqn, key);
        }
        catch (CacheException e) {
            logger.error("error flushing key: " + key, (Throwable)e);
        }
    }

    @Override
    public Collection<K> keys() {
        try {
            return this.cache.getKeys(this.fqn);
        }
        catch (CacheException e) {
            logger.error("error getting key set", (Throwable)e);
            return null;
        }
    }

    @Override
    public Collection<V> values() {
        HashSet values = Sets.newHashSet();
        Collection<K> keys = this.keys();
        if (keys == null) {
            return null;
        }
        for (K key : keys) {
            values.add(this.get(key));
        }
        return values;
    }

    @Override
    public void store() {
    }

    @Override
    public void load() {
    }
}

