/*
 * Decompiled with CFR 0.152.
 */
package org.yestech.cache.impl;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.lang.StringUtils;
import org.terracotta.cache.CacheConfig;
import org.terracotta.cache.CacheConfigFactory;
import org.terracotta.cache.DistributedCache;
import org.terracotta.modules.annotations.InstrumentedClass;
import org.terracotta.modules.annotations.Root;
import org.yestech.cache.ICacheManager;
import org.yestech.lib.util.Pair;

@InstrumentedClass
public class TerracottaDistributedCacheManager<K, V>
implements ICacheManager<K, V> {
    @Root
    private DistributedCache cache;
    private int maxTTIInSeconds;
    private int maxTTLInSeconds;
    private boolean orphanEvictionEnabled;
    private int orphanEvictionFrequency;
    private boolean enableLogging;
    private int targetMaxInMemoryCount;
    private int targetMaxTotalCount;
    private String name;

    @PostConstruct
    public void start() {
        CacheConfig builder = CacheConfigFactory.newConfig();
        if (this.maxTTIInSeconds > 0) {
            builder = builder.setMaxTTISeconds(this.maxTTIInSeconds);
        }
        if (this.maxTTLInSeconds > 0) {
            builder = builder.setMaxTTLSeconds(this.maxTTLInSeconds);
        }
        if (this.orphanEvictionEnabled) {
            builder = builder.setOrphanEvictionEnabled(this.orphanEvictionEnabled);
        }
        if (this.orphanEvictionFrequency > 0) {
            builder = builder.setOrphanEvictionPeriod(this.orphanEvictionFrequency);
        }
        if (this.targetMaxInMemoryCount > 0) {
            builder = builder.setTargetMaxInMemoryCount(this.targetMaxInMemoryCount);
        }
        if (this.targetMaxTotalCount > 0) {
            builder = builder.setTargetMaxTotalCount(this.targetMaxTotalCount);
        }
        if (this.enableLogging) {
            builder = builder.setLoggingEnabled(this.enableLogging);
        }
        if (StringUtils.isNotBlank((String)this.name)) {
            builder.setName(this.name);
        }
        this.cache = builder.newCache();
    }

    @PreDestroy
    public void stop() {
        if (this.cache != null) {
            this.cache.shutdown();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getTargetMaxInMemoryCount() {
        return this.targetMaxInMemoryCount;
    }

    public void setTargetMaxInMemoryCount(int targetMaxInMemoryCount) {
        this.targetMaxInMemoryCount = targetMaxInMemoryCount;
    }

    public int getTargetMaxTotalCount() {
        return this.targetMaxTotalCount;
    }

    public void setTargetMaxTotalCount(int targetMaxTotalCount) {
        this.targetMaxTotalCount = targetMaxTotalCount;
    }

    public long getOrphanEvictionFrequency() {
        return this.orphanEvictionFrequency;
    }

    public void setOrphanEvictionFrequency(int orphanEvictionFrequency) {
        this.orphanEvictionFrequency = orphanEvictionFrequency;
    }

    public boolean isOrphanEvictionEnabled() {
        return this.orphanEvictionEnabled;
    }

    public void setOrphanEvictionEnabled(boolean orphanEvictionEnabled) {
        this.orphanEvictionEnabled = orphanEvictionEnabled;
    }

    public boolean isEnableLogging() {
        return this.enableLogging;
    }

    public void setEnableLogging(boolean enableLogging) {
        this.enableLogging = enableLogging;
    }

    public int getMaxTTIInSeconds() {
        return this.maxTTIInSeconds;
    }

    public void setMaxTTIInSeconds(int maxTTIInSeconds) {
        this.maxTTIInSeconds = maxTTIInSeconds;
    }

    public int getMaxTTLInSeconds() {
        return this.maxTTLInSeconds;
    }

    public void setMaxTTLInSeconds(int maxTTLInSeconds) {
        this.maxTTLInSeconds = maxTTLInSeconds;
    }

    @Override
    public boolean contains(K k) {
        return this.cache.containsKey(k);
    }

    @Override
    public void putAll(Map<K, V> collection) {
        this.cache.putAll(collection);
    }

    @Override
    public void put(Pair<K, V> entry) {
        this.put(entry.getFirst(), entry.getSecond());
    }

    @Override
    public void put(K k, V v) {
        this.cache.putNoReturn(k, v);
    }

    @Override
    public V get(K key) {
        return (V)this.cache.get(key);
    }

    @Override
    public void flushAll() {
        this.cache.clear();
    }

    @Override
    public void flush(K key) {
        this.cache.removeNoReturn(key);
    }

    @Override
    public Collection<K> keys() {
        return this.cache.keySet();
    }

    @Override
    public Collection<V> values() {
        HashSet values = Sets.newHashSet();
        Collection<K> keys = this.keys();
        if (keys == null) {
            return null;
        }
        for (K key : keys) {
            values.add(this.get(key));
        }
        return values;
    }

    @Override
    public void store() {
    }

    @Override
    public void load() {
    }
}

