/*
 * Decompiled with CFR 0.152.
 */
package org.yestech.cache.spring;

import java.io.IOException;
import org.infinispan.Cache;
import org.infinispan.manager.CacheManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Required;

public class InfinispanFactoryBean
implements FactoryBean,
InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(InfinispanFactoryBean.class);
    private String cacheName;
    private Cache cache;
    private CacheManager manager;

    @Required
    public void setManager(CacheManager manager) {
        this.manager = manager;
    }

    @Required
    public void setCacheName(String cacheName) {
        this.cacheName = cacheName;
    }

    public void afterPropertiesSet() throws IOException {
        this.cache = this.manager.getCache(this.cacheName);
        this.cache.start();
    }

    public Object getObject() {
        return this.cache;
    }

    public Class getObjectType() {
        return this.cache != null ? this.cache.getClass() : Cache.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

