/*
 * Decompiled with CFR 0.152.
 */
package org.yestech.cache.spring;

import java.io.IOException;
import org.infinispan.Cache;
import org.infinispan.manager.CacheManager;
import org.infinispan.manager.DefaultCacheManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.core.io.Resource;

public class InfinispanManagerFactoryBean
implements FactoryBean,
InitializingBean,
DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(InfinispanManagerFactoryBean.class);
    private Resource configLocation;
    private CacheManager manager;

    @Required
    public void setConfigLocation(Resource configLocation) {
        this.configLocation = configLocation;
    }

    public void afterPropertiesSet() throws IOException {
        this.manager = new DefaultCacheManager(this.configLocation.getInputStream());
        this.manager.start();
    }

    public boolean isSingleton() {
        return true;
    }

    public void destroy() throws Exception {
        if (this.manager != null) {
            for (String cacheName : this.manager.getCacheNames()) {
                Cache cache = this.manager.getCache(cacheName);
                cache.stop();
            }
            this.manager.stop();
        }
    }

    public Object getObject() throws Exception {
        return this.manager;
    }

    public Class getObjectType() {
        return this.manager != null ? this.manager.getClass() : CacheManager.class;
    }
}

