/*
 * Decompiled with CFR 0.152.
 */
package org.yestech.cache.spring;

import java.io.IOException;
import org.apache.jcs.JCS;
import org.apache.jcs.access.exception.CacheException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Required;

public class JCSFactoryBean
implements FactoryBean,
InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(JCSFactoryBean.class);
    private String cacheName;
    private JCS cache;

    @Required
    public void setCacheName(String cacheName) {
        this.cacheName = cacheName;
    }

    public void afterPropertiesSet() throws IOException {
        try {
            this.cache = JCS.getInstance((String)this.cacheName);
        }
        catch (CacheException e) {
            logger.error("Error creating cache: " + this.cacheName, (Throwable)e);
            throw new RuntimeException("Error creating cache: " + this.cacheName, e);
        }
    }

    public Object getObject() {
        return this.cache;
    }

    public Class getObjectType() {
        return this.cache != null ? this.cache.getClass() : JCS.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

