/*
 * Decompiled with CFR 0.152.
 */
package org.yestech.cache.spring;

import java.io.IOException;
import java.util.Properties;
import org.apache.jcs.engine.control.CompositeCacheManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.core.io.Resource;

public class JCSManagerFactoryBean
implements FactoryBean,
InitializingBean,
DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(JCSManagerFactoryBean.class);
    private Resource configLocation;
    private CompositeCacheManager ccm;

    @Required
    public void setConfigLocation(Resource configLocation) {
        this.configLocation = configLocation;
    }

    public void afterPropertiesSet() throws IOException {
        this.ccm = CompositeCacheManager.getUnconfiguredInstance();
        Properties props = new Properties();
        props.load(this.configLocation.getInputStream());
        this.ccm.configure(props);
    }

    public boolean isSingleton() {
        return true;
    }

    public void destroy() throws Exception {
        if (this.ccm != null) {
            for (String cacheName : this.ccm.getCacheNames()) {
                this.ccm.freeCache(cacheName);
            }
            this.ccm.shutDown();
        }
    }

    public Object getObject() throws Exception {
        return this.ccm;
    }

    public Class getObjectType() {
        return this.ccm != null ? this.ccm.getClass() : CompositeCacheManager.class;
    }
}

