/*
 * Decompiled with CFR 0.152.
 */
package org.yestech.cache.spring;

import java.io.IOException;
import java.util.List;
import net.spy.memcached.AddrUtil;
import net.spy.memcached.MemcachedClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class MemcachedCacheFactoryBean
implements FactoryBean,
InitializingBean,
DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(MemcachedCacheFactoryBean.class);
    private MemcachedClient client;
    private List<String> servers;

    public MemcachedClient getClient() {
        return this.client;
    }

    public void setClient(MemcachedClient client) {
        this.client = client;
    }

    public List<String> getServers() {
        return this.servers;
    }

    public void setServers(List<String> servers) {
        this.servers = servers;
    }

    public void afterPropertiesSet() throws IOException {
        String serverList = "";
        for (String server : this.servers) {
            serverList = serverList + server + " ";
        }
        serverList = serverList.trim();
        this.client = new MemcachedClient(AddrUtil.getAddresses((String)serverList));
    }

    public boolean isSingleton() {
        return true;
    }

    public void destroy() throws Exception {
        this.client.shutdown();
    }

    public Object getObject() throws Exception {
        return this.client;
    }

    public Class getObjectType() {
        return this.client != null ? this.client.getClass() : MemcachedClient.class;
    }
}

