/*
 * Decompiled with CFR 0.152.
 */
package org.yestech.cache.spring;

import java.io.IOException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Required;
import org.tc.cache.CacheFactory;
import org.tc.cache.ITerracottaCache;

public abstract class TerracottaCacheFactoryBean
implements FactoryBean,
InitializingBean,
DisposableBean {
    private String cacheName;
    private ITerracottaCache cache;

    @Required
    public void setCacheName(String cacheName) {
        this.cacheName = cacheName;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public ITerracottaCache getCache() {
        return this.cache;
    }

    public void afterPropertiesSet() throws IOException {
        this.cache = this.getCacheInstance();
    }

    protected abstract ITerracottaCache getCacheInstance();

    public Object getObject() {
        return this.cache;
    }

    public Class getObjectType() {
        return this.cache != null ? this.cache.getClass() : this.getCacheType();
    }

    protected abstract Class<? extends ITerracottaCache> getCacheType();

    public boolean isSingleton() {
        return true;
    }

    public void destroy() throws Exception {
        CacheFactory.getInstance().destroyCache(this.cacheName);
    }
}

