/*
 * Decompiled with CFR 0.152.
 */
package org.yestech.episodic;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.DefaultHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yestech.episodic.EpisodicException;
import org.yestech.episodic.EpisodicService;
import org.yestech.episodic.TransportException;
import org.yestech.episodic.objectmodel.CreateAssetResponse;
import org.yestech.episodic.objectmodel.CreateEpisodeResponse;
import org.yestech.episodic.objectmodel.Episode;
import org.yestech.episodic.objectmodel.Episodes;
import org.yestech.episodic.objectmodel.ErrorResponse;
import org.yestech.episodic.objectmodel.Shows;
import org.yestech.episodic.util.EpisodicMultipartEntity;
import org.yestech.episodic.util.EpisodicUtil;

public class DefaultEpisodicService
implements EpisodicService {
    private static final Logger logger = LoggerFactory.getLogger(DefaultEpisodicService.class);
    protected static final String SCHEME = "http";
    protected static final String HOST = "api.episodic.com";
    protected static final int PORT = 80;
    protected static final String WRITE_API_PREFIX = "/api/v2/write/";
    protected static final String QUERY_API_PREFIX = "/api/v2/query/";
    protected String apiKey;
    protected String secret;
    protected HttpClient client;

    public DefaultEpisodicService(String secret, String apiKey) {
        this.secret = secret;
        this.apiKey = apiKey;
        this.client = new DefaultHttpClient();
    }

    public DefaultEpisodicService(String secret, String apiKey, String proxyHost, int proxyPort) {
        this(secret, apiKey);
        this.client.getParams().setParameter("http.route.default-proxy", (Object)new HttpHost(proxyHost, proxyPort));
    }

    @Override
    public void destroy() {
        this.client.getConnectionManager().shutdown();
    }

    @Override
    public String createAsset(String showId, String name, File file, String ... tags) {
        HttpPost method = new HttpPost(this.buildWriteURI("create_asset"));
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("expires", EpisodicUtil.expires());
            map.put("name", name);
            if (tags != null && tags.length > 0) {
                String tagString = EpisodicUtil.join(tags);
                map.put("tags", tagString);
            }
            map.put("show_id", String.valueOf(showId));
            String signature = this.generateSignature(this.secret, map);
            map.put("signature", signature);
            map.put("key", this.apiKey);
            EpisodicMultipartEntity multipartEntity = new EpisodicMultipartEntity();
            for (Map.Entry entry : map.entrySet()) {
                multipartEntity.addPart((String)entry.getKey(), (ContentBody)new StringBody((String)entry.getValue()));
            }
            multipartEntity.addPart("uploaded_data", (ContentBody)new FileBody(file));
            method.setEntity((HttpEntity)multipartEntity);
            HttpResponse response = this.client.execute((HttpUriRequest)method);
            this.checkStatus(response);
            Object o = EpisodicUtil.unmarshall(response);
            if (o instanceof ErrorResponse) {
                throw new EpisodicException((ErrorResponse)o);
            }
            if (o instanceof CreateAssetResponse) {
                return ((CreateAssetResponse)o).getAssetId();
            }
            throw new IllegalStateException("unknown response : " + o);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            method.abort();
            throw new TransportException(e.getMessage(), e);
        }
    }

    @Override
    public String createEpisode(String showId, String name, String[] assetIds, boolean publish, String description, String pingUrl, String ... tags) {
        HttpPost method = new HttpPost(this.buildWriteURI("create_episode"));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("expires", EpisodicUtil.expires());
        map.put("name", name);
        if (tags != null && tags.length > 0) {
            String tagString = EpisodicUtil.join(tags);
            map.put("tags", tagString);
        }
        map.put("show_id", String.valueOf(showId));
        map.put("publish", String.valueOf(publish));
        if (description != null) {
            map.put("description", description);
        }
        if (pingUrl != null) {
            map.put("ping_url", pingUrl);
        }
        map.put("asset_ids", EpisodicUtil.join(assetIds));
        if (pingUrl != null) {
            map.put("ping_url", pingUrl);
        }
        map.put("signature", this.generateSignature(this.secret, map));
        map.put("key", this.apiKey);
        try {
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(EpisodicUtil.toNameValuePairList(map), "UTF-8");
            method.setEntity((HttpEntity)entity);
            HttpResponse response = this.client.execute((HttpUriRequest)method);
            this.checkStatus(response);
            Object o = EpisodicUtil.unmarshall(response);
            if (o instanceof ErrorResponse) {
                throw new EpisodicException((ErrorResponse)o);
            }
            if (o instanceof CreateEpisodeResponse) {
                return ((CreateEpisodeResponse)o).getEpisodeId();
            }
            throw new IllegalStateException("unknown response : " + o);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            method.abort();
            throw new TransportException(e.getMessage(), e);
        }
    }

    @Override
    public Shows getShows(String[] showIds, EpisodicService.SortBy sortBy, EpisodicService.SortDir sortDir, Integer page, Integer perPage) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("expires", EpisodicUtil.expires());
        if (sortBy != null) {
            map.put("sort_by", sortBy.name());
        }
        if (sortDir != null) {
            map.put("sort_dir", sortDir.name());
        }
        if (page != null) {
            map.put("page", page.toString());
        }
        if (perPage != null) {
            map.put("per_page", perPage.toString());
        }
        if (showIds != null && showIds.length > 0) {
            map.put("id", EpisodicUtil.join(showIds));
        }
        map.put("signature", this.generateSignature(this.secret, map));
        map.put("key", this.apiKey);
        HttpGet method = new HttpGet(this.buildQueryURI("shows", map));
        try {
            HttpResponse response = this.client.execute((HttpUriRequest)method);
            this.checkStatus(response);
            Object o = EpisodicUtil.unmarshall(response);
            if (o instanceof ErrorResponse) {
                throw new EpisodicException((ErrorResponse)o);
            }
            if (o instanceof Shows) {
                return (Shows)o;
            }
            throw new IllegalStateException("unknown response : " + o);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            method.abort();
            throw new TransportException(e.getMessage(), e);
        }
    }

    @Override
    public Episodes getEpisodes(String[] showIds, String[] episodeIds, String searchTerm, EpisodicService.SearchType searchType, EpisodicService.TagMode tagMode, Episode.EpisodeStatus status, EpisodicService.SortBy sortBy, EpisodicService.SortDir sortDir, Boolean includeViews, Integer page, Integer perPage, Integer embedWidth, Integer embedHeight) {
        Map<String, String> map = this.buildEpisodeMap(showIds, episodeIds, searchTerm, searchType, tagMode, status, sortBy, sortDir, includeViews, page, perPage, embedWidth, embedHeight);
        map.put("signature", this.generateSignature(this.secret, map));
        map.put("key", this.apiKey);
        HttpGet method = new HttpGet(this.buildQueryURI("episodes", map));
        try {
            HttpResponse response = this.client.execute((HttpUriRequest)method);
            this.checkStatus(response);
            Object o = EpisodicUtil.unmarshall(response);
            if (o instanceof ErrorResponse) {
                throw new EpisodicException((ErrorResponse)o);
            }
            if (o instanceof Episodes) {
                return (Episodes)o;
            }
            throw new IllegalStateException("unknown response : " + o);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            method.abort();
            throw new TransportException(e.getMessage(), e);
        }
    }

    protected String generateSignature(String secret, Map<String, String> map) {
        return DigestUtils.sha256Hex((String)this.buildSignatureString(secret, map));
    }

    String buildSignatureString(String secret, Map<String, String> map) {
        StringBuilder builder = new StringBuilder(secret);
        SortedSet<String> keys = EpisodicUtil.sortedKeys(map);
        for (String key : keys) {
            builder.append(key).append('=').append(map.get(key));
        }
        return builder.toString();
    }

    private Map<String, String> buildEpisodeMap(String[] showIds, String[] episodeIds, String searchTerm, EpisodicService.SearchType searchType, EpisodicService.TagMode tagMode, Episode.EpisodeStatus status, EpisodicService.SortBy sortBy, EpisodicService.SortDir sortDir, Boolean includeViews, Integer page, Integer perPage, Integer embedWidth, Integer embedHeight) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("expires", EpisodicUtil.expires());
        if (showIds != null) {
            map.put("show_id", EpisodicUtil.join(showIds));
        }
        if (episodeIds != null) {
            map.put("id", EpisodicUtil.join(episodeIds));
        }
        if (searchTerm != null) {
            map.put("search_type", searchType.name());
        }
        if (tagMode != null) {
            map.put("tag_mode", tagMode.name());
        }
        if (status != null) {
            map.put("status", status.name());
        }
        if (sortBy != null) {
            map.put("sort_by", sortBy.name());
        }
        if (sortDir != null) {
            map.put("sort_dir", sortDir.name());
        }
        if (includeViews != null) {
            map.put("include_views", includeViews.toString());
        }
        if (page != null) {
            map.put("page", page.toString());
        }
        if (perPage != null) {
            map.put("per_page", perPage.toString());
        }
        if (embedWidth != null) {
            map.put("embed_width", embedWidth.toString());
        }
        if (embedHeight != null) {
            map.put("embed_height", embedHeight.toString());
        }
        return map;
    }

    private URI buildQueryURI(String call, Map<String, String> params) {
        List<NameValuePair> qparams = EpisodicUtil.toNameValuePairList(params);
        try {
            return URIUtils.createURI((String)SCHEME, (String)HOST, (int)80, (String)(QUERY_API_PREFIX + call), (String)URLEncodedUtils.format(qparams, (String)"UTF-8"), null);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    private URI buildWriteURI(String call) {
        try {
            return URIUtils.createURI((String)SCHEME, (String)HOST, (int)80, (String)(WRITE_API_PREFIX + call), null, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    private void checkStatus(HttpResponse response) {
        StatusLine statusLine = response.getStatusLine();
        if (statusLine.getStatusCode() != 200) {
            throw new EpisodicException(statusLine.getStatusCode(), statusLine.getReasonPhrase());
        }
    }
}

