/*
 * Decompiled with CFR 0.152.
 */
package org.yestech.episodic;

import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.yestech.episodic.DefaultEpisodicService;
import org.yestech.episodic.EpisodicException;
import org.yestech.episodic.EpisodicService;
import org.yestech.episodic.objectmodel.Episode;
import org.yestech.episodic.objectmodel.Episodes;
import org.yestech.episodic.objectmodel.Shows;

public class Main {
    @Option(required=true, name="-o", aliases={"--operation"}, usage="Operation to run")
    private Operation operation;
    @Option(required=true, name="-api", aliases={"--api-key"}, usage="Sets the api key")
    private String apiKey;
    @Option(required=true, name="-s", aliases={"--secret"}, usage="Sets the episodic secret key")
    private String secret;
    @Option(name="-page", usage="Set the number of pages to return in the result")
    private Integer page;
    @Option(name="-per-page", usage="Number of results per page")
    private Integer perPage;
    @Option(name="-show", usage="Sets a show id [list_episodes ,list_shows]", multiValued=true)
    private List<String> showIds = new ArrayList<String>();
    @Option(name="-sort", usage="How to sort the results (update_at, created_at, name) [list_episodes,list_shows]")
    private EpisodicService.SortBy sortBy;
    @Option(name="-sort-dir", usage="Direction to sort by (asc, dsc) [list_episodes,list_shows]")
    private EpisodicService.SortDir sortDir;
    @Option(name="-episode", usage="List of episode ids [list_episodes]")
    private List<String> episodeIds = new ArrayList<String>();
    @Option(name="-search-term", usage="Search term [list_episode]")
    private String searchTerm;
    @Option(name="-tag-mode", usage="Tag Mode (any, all) [list_episode]")
    private EpisodicService.TagMode tagMode;
    @Option(name="-episode-status", usage="Status of episode (off_the_air,publishing,on_the_air,waiting_to_air,publish_failed) [list_episodes]")
    private Episode.EpisodeStatus episodeStatus;
    @Option(name="-include-views", usage="Whether or not to include the total number of views (true, false) [list_episodes]")
    private Boolean includeViews;
    @Option(name="-embed-width", usage="An integer value in pixels that specifies the width of the video [list_episode]")
    private Integer embedWidth;
    @Option(name="-embed-height", usage="An integer value in pixels that specifies the height of the video [list_episode]")
    private Integer embedHeight;
    @Option(name="-search-type", usage="The search_type parameter must be one of \"tags\", \"name_description\" or \"all\". The default is \"all\". [list_episode]")
    private EpisodicService.SearchType searchType;
    @Option(name="-name", usage="Name of the thing object to be created [create_episode (required), create_asset (required)]")
    private String name;
    @Option(name="-file", usage="File to upload as an asset [create_asset (required)]")
    private File file;
    @Option(name="-tag", multiValued=true, usage="Tag to applied to the asset or episode [create_episode, create_asset]")
    private List<String> tags = new ArrayList<String>();
    @Option(name="-publish", usage="Whether a created episode should be published, default false [create_episode]")
    private boolean publish = false;
    @Option(name="-desc", usage="Description of a created episode [create_episode]")
    private String description;
    @Option(name="-asset", usage="id of an asset [create_episode (required)]")
    private List<String> assetIds;
    @Option(name="-pingUrl", usage="Url for the application to ping back after publish [create_episode]")
    private String pingUrl;
    @Option(name="-proxy-port", usage="Port for http proxy")
    private Integer proxyPort;
    @Option(name="-proxy-host", usage="Host for proxy")
    private String proxyHost;

    String[] shows() {
        return this.showIds.toArray(new String[this.showIds.size()]);
    }

    String[] episodes() {
        return this.episodeIds.toArray(new String[this.episodeIds.size()]);
    }

    String[] tags() {
        return this.tags.toArray(new String[this.tags.size()]);
    }

    String[] assets() {
        return this.assetIds.toArray(new String[this.assetIds.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Main main = new Main();
        CmdLineParser parser = new CmdLineParser((Object)main);
        parser.setUsageWidth(80);
        try {
            parser.parseArgument(args);
            DefaultEpisodicService service = main.proxyHost != null && main.proxyPort != null ? new DefaultEpisodicService(main.secret, main.apiKey, main.proxyHost, main.proxyPort) : new DefaultEpisodicService(main.secret, main.apiKey);
            try {
                System.out.println("Executing: " + main.toString());
                Serializable xmlResult = null;
                if (main.operation == Operation.list_shows) {
                    xmlResult = Main.list_shows(service, main);
                } else if (main.operation == Operation.list_episodes) {
                    xmlResult = Main.list_episodes(service, main);
                } else if (main.operation == Operation.create_asset) {
                    String assetId = Main.create_asset(service, main);
                    System.out.println("Successfully created asset with id " + assetId);
                } else if (main.operation == Operation.create_episode) {
                    String episodeId = Main.create_episode(service, main);
                    System.out.println("Successfully created episode with id " + episodeId);
                } else if (main.operation == Operation.full_create) {
                    String episodeId = Main.full_create(service, main);
                    System.out.println("Successfully created episode with id " + episodeId);
                }
                if (xmlResult != null) {
                    Main.displayXmlResult(xmlResult);
                }
            }
            finally {
                service.destroy();
            }
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            System.err.println("java Main [options...] arguments...");
            parser.printUsage((OutputStream)System.err);
            System.err.println();
            System.exit(1);
        }
        catch (EpisodicException e) {
            System.err.print(e.getMessage() + " Code: " + e.getCode());
            e.printStackTrace();
            System.exit(1);
        }
        catch (JAXBException e) {
            System.err.print(e.getMessage());
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static Shows list_shows(EpisodicService service, Main main) throws JAXBException {
        return service.getShows(main.shows(), main.sortBy, main.sortDir, main.page, main.perPage);
    }

    private static Episodes list_episodes(EpisodicService service, Main main) {
        return service.getEpisodes(main.shows(), main.episodes(), main.searchTerm, main.searchType, main.tagMode, main.episodeStatus, main.sortBy, main.sortDir, main.includeViews, main.page, main.perPage, main.embedWidth, main.embedHeight);
    }

    private static String create_asset(EpisodicService service, Main main) throws CmdLineException {
        if (main.name == null) {
            throw new CmdLineException("name is required for create_asset");
        }
        if (main.showIds == null || main.showIds.isEmpty() || main.showIds.size() > 1) {
            throw new CmdLineException("1 and only show is required for create_asset");
        }
        if (main.file == null) {
            throw new CmdLineException("file is required");
        }
        return service.createAsset(main.showIds.get(0), main.name, main.file, main.tags());
    }

    private static String create_episode(EpisodicService service, Main main) throws CmdLineException {
        if (main.name == null) {
            throw new CmdLineException("name is required for create_episode");
        }
        if (main.showIds == null || main.showIds.isEmpty() || main.showIds.size() > 1) {
            throw new CmdLineException("1 and only show is required for create_episode");
        }
        return service.createEpisode(main.showIds.get(0), main.name, main.assets(), main.publish, main.description, main.pingUrl, main.tags());
    }

    private static String full_create(EpisodicService service, Main main) throws CmdLineException {
        if (main.name == null) {
            throw new CmdLineException("name is required for full_create");
        }
        if (main.showIds == null || main.showIds.isEmpty() || main.showIds.size() > 1) {
            throw new CmdLineException("1 and only show is required for full_create");
        }
        if (main.file == null) {
            throw new CmdLineException("file is required");
        }
        if (main.file == null) {
            throw new CmdLineException("file is required");
        }
        String assetId = service.createAsset(main.showIds.get(0), main.name, main.file, main.tags());
        System.out.println("Created asset --> " + assetId);
        return service.createEpisode(main.showIds.get(0), main.name, new String[]{assetId}, main.publish, main.description, main.pingUrl, main.tags());
    }

    public static void displayXmlResult(Object result) throws JAXBException {
        System.out.println("XML Response:");
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{result.getClass()});
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        marshaller.marshal(result, (OutputStream)System.out);
    }

    public String toString() {
        return "Main{operation=" + (Object)((Object)this.operation) + ", apiKey='" + this.apiKey + '\'' + ", secret='" + this.secret + '\'' + ", page=" + this.page + ", perPage=" + this.perPage + ", showIds=" + this.showIds + ", sortBy=" + (Object)((Object)this.sortBy) + ", sortDir=" + (Object)((Object)this.sortDir) + ", episodeIds=" + this.episodeIds + ", searchTerm='" + this.searchTerm + '\'' + ", tagMode=" + (Object)((Object)this.tagMode) + ", episodeStatus=" + (Object)((Object)this.episodeStatus) + ", includeViews=" + this.includeViews + ", embedWidth=" + this.embedWidth + ", embedHeight=" + this.embedHeight + ", searchType=" + (Object)((Object)this.searchType) + '}';
    }

    public static enum Operation {
        list_shows,
        list_episodes,
        create_episode,
        create_asset,
        full_create;

    }
}

