/*
 * Decompiled with CFR 0.152.
 */
package org.yestech.episodic.objectmodel;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.joda.time.DateTime;
import org.yestech.episodic.objectmodel.Download;
import org.yestech.episodic.objectmodel.Player;
import org.yestech.episodic.objectmodel.Players;
import org.yestech.episodic.objectmodel.Thumbnail;
import org.yestech.episodic.util.CommaSeperatedStringArrayXmlConverter;
import org.yestech.episodic.util.DateXmlAdapter;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="episode")
public class Episode
implements Serializable {
    @XmlElement
    protected String id;
    @XmlElement
    protected String name;
    @XmlElement
    protected String description;
    @XmlElement
    @XmlJavaTypeAdapter(value=CommaSeperatedStringArrayXmlConverter.class)
    protected String[] tags;
    @XmlElement(name="air_date")
    @XmlJavaTypeAdapter(value=DateXmlAdapter.class)
    protected DateTime airDate;
    @XmlElement
    protected String duration;
    @XmlElement
    protected EpisodeStatus status;
    @XmlElementWrapper(name="thumbnails")
    @XmlElements(value={@XmlElement(name="thumbnail", type=Thumbnail.class)})
    protected List<Thumbnail> thumbnails;
    protected Players players;
    @XmlElementWrapper(name="downloads")
    @XmlElements(value={@XmlElement(name="download", type=Download.class)})
    protected List<Download> downloads;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String[] getTags() {
        return this.tags;
    }

    public void setTags(String[] tags) {
        this.tags = tags;
    }

    public DateTime getAirDate() {
        return this.airDate;
    }

    public void setAirDate(DateTime airDate) {
        this.airDate = airDate;
    }

    public String getDuration() {
        return this.duration;
    }

    public void setDuration(String duration) {
        this.duration = duration;
    }

    public EpisodeStatus getStatus() {
        return this.status;
    }

    public void setStatus(EpisodeStatus status) {
        this.status = status;
    }

    public List<Thumbnail> getThumbnails() {
        return this.thumbnails;
    }

    public void setThumbnails(List<Thumbnail> thumbnails) {
        this.thumbnails = thumbnails;
    }

    public Players getPlayers() {
        return this.players;
    }

    public void setPlayers(Players players) {
        this.players = players;
    }

    public List<Download> getDownloads() {
        return this.downloads;
    }

    public void setDownloads(List<Download> downloads) {
        this.downloads = downloads;
    }

    public Player getDefaultPlayer() {
        if (this.players != null && this.players.getPlayers() != null && !this.players.getPlayers().isEmpty()) {
            for (Player player : this.players.getPlayers()) {
                if (!player.isDefaultPlayer()) continue;
                return player;
            }
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Episode episode = (Episode)o;
        if (this.airDate != null ? !this.airDate.equals((Object)episode.airDate) : episode.airDate != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(episode.description) : episode.description != null) {
            return false;
        }
        if (this.downloads != null ? !((Object)this.downloads).equals(episode.downloads) : episode.downloads != null) {
            return false;
        }
        if (this.duration != null ? !this.duration.equals(episode.duration) : episode.duration != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(episode.id) : episode.id != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(episode.name) : episode.name != null) {
            return false;
        }
        if (this.players != null ? !this.players.equals(episode.players) : episode.players != null) {
            return false;
        }
        if (this.status != episode.status) {
            return false;
        }
        if (!Arrays.equals(this.tags, episode.tags)) {
            return false;
        }
        return !(this.thumbnails != null ? !((Object)this.thumbnails).equals(episode.thumbnails) : episode.thumbnails != null);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.tags != null ? Arrays.hashCode(this.tags) : 0);
        result = 31 * result + (this.airDate != null ? this.airDate.hashCode() : 0);
        result = 31 * result + (this.duration != null ? this.duration.hashCode() : 0);
        result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
        result = 31 * result + (this.thumbnails != null ? ((Object)this.thumbnails).hashCode() : 0);
        result = 31 * result + (this.players != null ? this.players.hashCode() : 0);
        result = 31 * result + (this.downloads != null ? ((Object)this.downloads).hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Episode{id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", tags=" + (this.tags == null ? null : Arrays.asList(this.tags)) + ", airDate=" + this.airDate + ", duration='" + this.duration + '\'' + ", status=" + (Object)((Object)this.status) + ", thumbnails=" + this.thumbnails + ", players=" + this.players + ", downloads=" + this.downloads + '}';
    }

    public static enum EpisodeStatus {
        off_the_air,
        publishing,
        on_the_air,
        waiting_to_air,
        publish_failed;

    }
}

