/*
 * Decompiled with CFR 0.152.
 */
package org.yestech.episodic.util;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yestech.episodic.objectmodel.CreateAssetResponse;
import org.yestech.episodic.objectmodel.CreateEpisodeResponse;
import org.yestech.episodic.objectmodel.Episodes;
import org.yestech.episodic.objectmodel.ErrorResponse;
import org.yestech.episodic.objectmodel.Shows;

public final class EpisodicUtil {
    private static Logger logger = LoggerFactory.getLogger(EpisodicUtil.class);
    private static JAXBContext ctx;

    private EpisodicUtil() {
    }

    public static Object unmarshall(HttpResponse response) throws JAXBException, IOException {
        String xml = EntityUtils.toString((HttpEntity)response.getEntity());
        Unmarshaller unmarshaller = ctx.createUnmarshaller();
        return unmarshaller.unmarshal((Reader)new StringReader(xml));
    }

    public static String join(String[] strings) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < strings.length; ++i) {
            builder.append(strings[i]);
            if (i + 1 >= strings.length) continue;
            builder.append(",");
        }
        return builder.toString();
    }

    public static String expires() {
        DateTime dt = new DateTime(DateTimeZone.UTC).plusMinutes(15);
        return String.valueOf(dt.getMillis() / 1000L);
    }

    public static SortedSet<String> sortedKeys(Map<String, String> map) {
        return new TreeSet<String>(map.keySet());
    }

    public static List<NameValuePair> toNameValuePairList(Map<String, String> map) {
        ArrayList<NameValuePair> pairs = new ArrayList<NameValuePair>(map.size());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            pairs.add((NameValuePair)new BasicNameValuePair(entry.getKey(), entry.getValue()));
        }
        return pairs;
    }

    static {
        try {
            ctx = JAXBContext.newInstance((Class[])new Class[]{ErrorResponse.class, CreateAssetResponse.class, CreateEpisodeResponse.class, Episodes.class, Shows.class});
        }
        catch (JAXBException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

