/*
 * Decompiled with CFR 0.152.
 */
package org.yestech.event.event;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;

public class EventFactory {
    public static <E> E create(Class<E> event) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Class[] interfaces = new Class[]{event};
        Object proxy = Proxy.newProxyInstance(loader, interfaces, (InvocationHandler)new EventInvocationHandler());
        return (E)proxy;
    }

    private static class EventInvocationHandler
    implements InvocationHandler {
        private Map<String, Object> methods = new ConcurrentHashMap<String, Object>();
        private static final String SET_METHOD_PREFIX = "set";
        private static final String GET_METHOD_PREFIX = "get";
        private static final String IS_METHOD_PREFIX = "is";

        private EventInvocationHandler() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object result = null;
            if (method != null) {
                String methodName = method.getName();
                if (StringUtils.startsWith((String)methodName, (String)SET_METHOD_PREFIX)) {
                    String strippedMethodName = this.extractMethodName(methodName, SET_METHOD_PREFIX);
                    this.methods.put(strippedMethodName, args[0]);
                } else if (StringUtils.startsWith((String)methodName, (String)GET_METHOD_PREFIX)) {
                    String strippedMethodName = this.extractMethodName(methodName, GET_METHOD_PREFIX);
                    result = this.methods.get(strippedMethodName);
                } else if (StringUtils.startsWith((String)methodName, (String)IS_METHOD_PREFIX)) {
                    String strippedMethodName = this.extractMethodName(methodName, IS_METHOD_PREFIX);
                    result = this.methods.get(strippedMethodName);
                } else {
                    throw new RuntimeException("not a valid method current: " + methodName);
                }
            }
            return result;
        }

        private String extractMethodName(String methodName, String prefixToStrip) {
            String strippedMethodName = StringUtils.removeStart((String)methodName, (String)prefixToStrip);
            return strippedMethodName;
        }
    }
}

