/*
 * Decompiled with CFR 0.152.
 */
package org.yestech.event.multicaster;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.yestech.event.AggregateResultReference;
import org.yestech.event.InvalidListenerException;
import org.yestech.event.ResultReference;
import org.yestech.event.annotation.AsyncListener;
import org.yestech.event.annotation.RegisterEvent;
import org.yestech.event.annotation.RegisteredEvents;
import org.yestech.event.event.IEvent;
import org.yestech.event.listener.BaseListener;
import org.yestech.event.listener.IAggregateListener;
import org.yestech.event.listener.IListener;
import org.yestech.event.multicaster.BaseEventMulticaster;

@Component(value="aggregatingEventMulticaster")
public class AggregatingEventMulticaster<EVENT extends IEvent, RESULT extends AggregateResultReference>
extends BaseEventMulticaster<EVENT, AggregateResultReference> {
    private static final Logger logger = LoggerFactory.getLogger(AggregatingEventMulticaster.class);
    private final Multimap<Class, ListenerAdapter> listenerMap = ArrayListMultimap.create();
    private List<IAggregateListener> listeners = Lists.newArrayList();

    @Override
    public <L extends IListener> void registerListener(L listener) {
        this.listeners.add((IAggregateListener)listener);
    }

    public void setListeners(List<IAggregateListener> listeners) {
        this.listeners = listeners;
    }

    public List<IAggregateListener> getListeners() {
        return this.listeners;
    }

    @Override
    @PostConstruct
    public void init() {
        this.addListeners(this.listeners);
        this.initializeThreadPool();
    }

    protected void addListeners(List<IAggregateListener> listeners) {
        HashMap tempListenerMap = Maps.newHashMap();
        if (listeners != null) {
            for (IAggregateListener listener : listeners) {
                RegisteredEvents listenedEvents = listener.getClass().getAnnotation(RegisteredEvents.class);
                if (listenedEvents != null) {
                    for (RegisterEvent eventClass : listenedEvents.events()) {
                        Class<? extends IEvent> event = eventClass.event();
                        Integer order = eventClass.order();
                        ListenerContainer container = new ListenerContainer();
                        container.setListener(listener);
                        container.setOrder(order);
                        List tempListenerList = (List)tempListenerMap.get(event);
                        if (tempListenerList == null) {
                            tempListenerList = Lists.newArrayList();
                            tempListenerMap.put(event, tempListenerList);
                        }
                        tempListenerList.add(container);
                    }
                    continue;
                }
                String msg = String.format("%s must contain an RegisteredEvents annotation", listener.getClass().getSimpleName());
                logger.error(msg);
                throw new InvalidListenerException(msg);
            }
            this.reorderListeners(tempListenerMap);
        }
    }

    Multimap<Class, ListenerAdapter> getListenerMap() {
        return this.listenerMap;
    }

    @Override
    public AggregateResultReference process(EVENT event) {
        Collection list = this.listenerMap.get(event.getClass());
        AggregateResultReference aggregateReference = new AggregateResultReference();
        if (list != null && !list.isEmpty()) {
            for (ListenerAdapter listener : list) {
                ResultReference ref = new ResultReference();
                if (listener.isAsync()) {
                    this.processAsync(event, ref, listener);
                } else {
                    listener.handle((IEvent)event, ref);
                }
                Object result = ref.getResult();
                this.validate(event, result);
                aggregateReference.addResult(listener.getToken(), ref);
            }
        }
        return aggregateReference;
    }

    protected void addListener(Class<? extends IEvent> event, IAggregateListener listener) {
        this.listenerMap.put(event, new ListenerAdapter(listener));
    }

    private void reorderListeners(Map<Class, List<ListenerContainer>> tempListenerMap) {
        for (Map.Entry<Class, List<ListenerContainer>> tempEntry : tempListenerMap.entrySet()) {
            Class event = tempEntry.getKey();
            List<ListenerContainer> tempListenersList = tempEntry.getValue();
            Collections.sort(tempListenersList);
            for (ListenerContainer listenerContainer : tempListenersList) {
                this.addListener(event, listenerContainer.getListener());
            }
        }
    }

    private class ListenerContainer
    implements Comparable<ListenerContainer> {
        private IAggregateListener listener;
        private Integer order;

        private ListenerContainer() {
        }

        public IAggregateListener getListener() {
            return this.listener;
        }

        public void setListener(IAggregateListener listener) {
            this.listener = listener;
        }

        public Integer getOrder() {
            return this.order;
        }

        public void setOrder(Integer order) {
            this.order = order;
        }

        @Override
        public int compareTo(ListenerContainer compare) {
            return this.order.compareTo(compare.getOrder());
        }
    }

    class ListenerAdapter<EVENT extends IEvent, RESULT>
    extends BaseListener
    implements IAggregateListener {
        private IAggregateListener adaptee;
        private boolean async;

        public Enum getToken() {
            return this.adaptee.getToken();
        }

        public void setToken(Enum token) {
            this.adaptee.setToken(token);
        }

        public ListenerAdapter(IAggregateListener adaptee) {
            this.adaptee = adaptee;
            this.async = adaptee.getClass().isAnnotationPresent(AsyncListener.class);
        }

        public boolean isAsync() {
            return this.async;
        }

        public IAggregateListener getAdaptee() {
            return this.adaptee;
        }

        @Override
        public void handle(IEvent event, ResultReference result) {
            this.adaptee.handle(event, result);
        }

        @Override
        public void deregister() {
            this.getMulticaster().deregisterListener(this.adaptee);
        }

        @Override
        public void register() {
            this.getMulticaster().registerListener(this.adaptee);
        }
    }
}

