/*
 * Decompiled with CFR 0.152.
 */
package org.yestech.event.multicaster;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yestech.event.InvalidResultException;
import org.yestech.event.ResultReference;
import org.yestech.event.annotation.EventResultType;
import org.yestech.event.event.EventUtils;
import org.yestech.event.event.IEvent;
import org.yestech.event.listener.IListener;
import org.yestech.event.multicaster.IEventMulticaster;

public abstract class BaseEventMulticaster<EVENT extends IEvent, RESULT>
implements IEventMulticaster<EVENT, RESULT> {
    private static final Logger logger = LoggerFactory.getLogger(BaseEventMulticaster.class);
    private boolean checkResultType;
    private ExecutorService pool;
    private int corePoolSize = 1;
    private int maximumPoolSize = 10;
    private long keepAliveTime = 60L;

    @Override
    public <L extends IListener> void deregisterListener(L listener) {
    }

    @Override
    public <L extends IListener> void registerListener(L listener) {
    }

    public ExecutorService getPool() {
        return this.pool;
    }

    public void setPool(ExecutorService pool) {
        this.pool = pool;
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    public void setCorePoolSize(int corePoolSize) {
        this.corePoolSize = corePoolSize;
    }

    public int getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    public void setMaximumPoolSize(int maximumPoolSize) {
        this.maximumPoolSize = maximumPoolSize;
    }

    public long getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public void setKeepAliveTime(long keepAliveTime) {
        this.keepAliveTime = keepAliveTime;
    }

    @Override
    public boolean isCheckResultType() {
        return this.checkResultType;
    }

    @Override
    public void setCheckResultType(boolean resultTypeCheck) {
        this.checkResultType = resultTypeCheck;
    }

    @PreDestroy
    public void destroy() {
        if (this.pool != null) {
            this.getPool().shutdown();
        }
    }

    @PostConstruct
    public void init() {
    }

    protected void initializeThreadPool() {
        if (this.pool == null) {
            this.pool = new ThreadPoolExecutor(this.corePoolSize, this.maximumPoolSize, this.keepAliveTime, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        }
    }

    protected void processAsync(EVENT event, ResultReference<RESULT> ref, final IListener listener) {
        this.pool.execute(new Runnable((IEvent)event, ref){
            final /* synthetic */ IEvent val$event;
            final /* synthetic */ ResultReference val$ref;
            {
                this.val$event = iEvent;
                this.val$ref = resultReference;
            }

            @Override
            public void run() {
                listener.handle(this.val$event, this.val$ref);
            }
        });
    }

    protected void validate(EVENT event, Object result) {
        EventResultType resultType;
        if (this.checkResultType && result != null && (resultType = EventUtils.getResultType(event)) != null && resultType.value() != null && !resultType.value().isAssignableFrom(result.getClass())) {
            String msg = String.format("%s Requires that a type of %s was returned", event.getClass().getSimpleName(), resultType.getClass().getSimpleName());
            logger.error(msg);
            throw new InvalidResultException(msg);
        }
    }
}

