/*
 * Decompiled with CFR 0.152.
 */
package org.yestech.event.multicaster;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.impl.DefaultMessage;
import org.apache.camel.impl.DefaultProducerTemplate;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.yestech.event.annotation.EventResultType;
import org.yestech.event.event.EventUtils;
import org.yestech.event.event.ICamelEvent;
import org.yestech.event.multicaster.BaseEventMulticaster;

@Component(value="camelEventMulticaster")
public class CamelEventMulticaster<EVENT extends ICamelEvent, RESULT>
extends BaseEventMulticaster<EVENT, RESULT> {
    private static final Logger logger = LoggerFactory.getLogger(CamelEventMulticaster.class);
    private Map<String, CamelContext> contexts = new HashMap<String, CamelContext>();
    private CamelContext defaultContext;

    public Map<String, CamelContext> getContexts() {
        return this.contexts;
    }

    public void setContexts(Map<String, CamelContext> contexts) {
        this.contexts = contexts;
    }

    public CamelContext getDefaultContext() {
        return this.defaultContext;
    }

    public void setDefaultContext(CamelContext defaultContext) {
        this.defaultContext = defaultContext;
    }

    @Override
    public RESULT process(EVENT event) {
        CamelContext context = this.defaultContext;
        if (context == null) {
            context = this.contexts.get(event.getEventName());
        }
        if (context == null) {
            throw new RuntimeException("context not found....");
        }
        DefaultProducerTemplate template = (DefaultProducerTemplate)context.createProducerTemplate();
        Object result = null;
        if (StringUtils.isNotBlank((String)event.getDefaultEndPointUri())) {
            Endpoint endpoint = context.getEndpoint(event.getDefaultEndPointUri());
            template.setDefaultEndpoint(endpoint);
            Exchange exchange = endpoint.createExchange();
            DefaultMessage message = new DefaultMessage();
            message.setBody(event);
            exchange.setIn((Message)message);
            exchange = template.send(exchange);
            result = this.wantsExchange(event) ? exchange : (exchange.hasOut() ? exchange.getOut().getBody() : exchange.getIn().getBody());
        } else {
            throw new RuntimeException("need to set a defaultEndPointUri");
        }
        this.validate(event, result);
        return (RESULT)result;
    }

    private boolean wantsExchange(EVENT event) {
        EventResultType resultType = EventUtils.getResultType(event);
        return resultType != null && resultType.value().isAssignableFrom(Exchange.class);
    }
}

