/*
 * Decompiled with CFR 0.152.
 */
package org.yestech.event.multicaster;

import java.util.List;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.yestech.event.InvalidListenerException;
import org.yestech.event.annotation.ListenedEvents;
import org.yestech.event.event.IEvent;
import org.yestech.event.listener.IListener;
import org.yestech.event.multicaster.DefaultEventMulticaster;

@Component(value="defaultOrderEventMulticaster")
public class DefaultOrderEventMulticaster<EVENT extends IEvent, RESULT>
extends DefaultEventMulticaster<EVENT, RESULT> {
    private static final Logger logger = LoggerFactory.getLogger(DefaultOrderEventMulticaster.class);
    private List<List<IListener>> listenerGroups;

    public List<List<IListener>> getListenerGroups() {
        return this.listenerGroups;
    }

    public void setListenerGroups(List<List<IListener>> listenerGroups) {
        this.listenerGroups = listenerGroups;
    }

    @Override
    @PostConstruct
    public void init() {
        this.addListeners(this.getListeners());
        if (this.listenerGroups != null) {
            for (List<IListener> listenerGroup : this.listenerGroups) {
                this.addListeners(listenerGroup);
            }
        }
        this.initializeThreadPool();
    }

    @Override
    protected void addListeners(List<IListener> listeners) {
        if (listeners != null) {
            for (IListener listener : listeners) {
                ListenedEvents listenedEvents = listener.getClass().getAnnotation(ListenedEvents.class);
                if (listenedEvents != null) {
                    for (Class<? extends IEvent> eventClass : listenedEvents.value()) {
                        if (logger.isDebugEnabled()) {
                            logger.debug(String.format("Listener %s Registered against Event %s", listener.getClass().getSimpleName(), eventClass.getSimpleName()));
                        }
                        this.addListener(eventClass, listener);
                    }
                    continue;
                }
                String msg = String.format("%s must contain an ListenedEvents annotation", listener.getClass().getSimpleName());
                logger.error(msg);
                throw new InvalidListenerException(msg);
            }
        }
    }
}

