/*
 * Decompiled with CFR 0.152.
 */
package org.yestech.lib.camel;

import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.impl.DefaultComponent;
import org.apache.commons.lang.StringUtils;
import org.terracotta.message.pipe.BlockingQueueBasedPipe;
import org.terracotta.message.pipe.Pipe;
import org.terracotta.message.topology.DefaultTopology;
import org.terracotta.message.topology.Topology;
import org.terracotta.message.topology.TopologyManager;
import org.yestech.lib.camel.TerracottaEndpoint;

public class TerracottaComponent
extends DefaultComponent {
    public Pipe<Object> createPipe(String uri, Map parameters) {
        int pipeSize = (Integer)this.getAndRemoveParameter(parameters, "size", Integer.class, 1000);
        String topologyName = (String)this.getAndRemoveParameter(parameters, "topologyName", String.class);
        String pipeName = (String)this.getAndRemoveParameter(parameters, "pipeName", String.class);
        BlockingQueueBasedPipe.Factory pipeFactory = new BlockingQueueBasedPipe.Factory(pipeSize);
        DefaultTopology.Factory topologyFactory = new DefaultTopology.Factory((Pipe.Factory)pipeFactory);
        Topology topology = TopologyManager.getInstance().getOrCreateTopology(topologyName, (Topology.Factory)topologyFactory);
        Pipe pipe = StringUtils.isNotBlank((String)pipeName) ? topology.getOrCreatePipeFor((Object)pipeName) : topology.getOrCreatePipeFor((Object)topologyName);
        return pipe;
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map parameters) throws Exception {
        int consumers = (Integer)this.getAndRemoveParameter(parameters, "concurrentConsumers", Integer.class, 1);
        return new TerracottaEndpoint(uri, (Component)this, this.createPipe(uri, parameters), consumers);
    }
}

