/*
 * Decompiled with CFR 0.152.
 */
package org.yestech.lib.camel;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.impl.DefaultProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.message.pipe.Pipe;
import org.yestech.lib.camel.TerracottaEndpoint;

public class TerracottaProducer
extends DefaultProducer {
    private static final Logger logger = LoggerFactory.getLogger(TerracottaProducer.class);
    private final Pipe<Object> queue;
    private TerracottaEndpoint endpoint;

    public TerracottaProducer(TerracottaEndpoint endpoint, Pipe<Object> queue) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
        this.queue = queue;
    }

    public void process(Exchange exchange) throws Exception {
        this.queue.put((Object)exchange.copy());
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.endpoint.onStarted(this);
    }

    protected void doStop() throws Exception {
        this.endpoint.onStopped(this);
        super.doStop();
    }
}

