/*
 * Decompiled with CFR 0.152.
 */
package org.yestech.lib.crypto;

import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AesUtils {
    private static final Logger logger = LoggerFactory.getLogger(AesUtils.class);
    private static final Hex hexCodec = new Hex();
    private static final String DEFAULT_KEY = "waZkAoftB0MIfEuNsh12RA==";
    private static String encryptionKey = "waZkAoftB0MIfEuNsh12RA==";

    private AesUtils() {
    }

    public static void setEnryptionKey(String key) {
        encryptionKey = key;
    }

    public static String getEnryptionKey() {
        return encryptionKey;
    }

    public static String encrypt(long value) {
        return AesUtils.encrypt(AesUtils.getEnryptionKey(), value);
    }

    public static String encrypt(int value) {
        return AesUtils.encrypt(AesUtils.getEnryptionKey(), value);
    }

    public static String encrypt(String message) {
        return AesUtils.encrypt(AesUtils.getEnryptionKey(), message);
    }

    public static String encryptBase64(long value) {
        return AesUtils.encryptBase64(AesUtils.getEnryptionKey(), value);
    }

    public static String encryptBase64(int value) {
        return AesUtils.encryptBase64(AesUtils.getEnryptionKey(), value);
    }

    public static String encryptBase64(String message) {
        return AesUtils.encryptBase64(AesUtils.getEnryptionKey(), message);
    }

    public static String generateKey() {
        return AesUtils.generateKey(128);
    }

    public static String generateKey(int keySize) {
        String key = "";
        KeyGenerator kgen = null;
        try {
            kgen = KeyGenerator.getInstance("AES");
            kgen.init(keySize);
            SecretKey skey = kgen.generateKey();
            byte[] raw = skey.getEncoded();
            key = new String(Base64.encodeBase64((byte[])raw));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return key;
    }

    public static String encrypt(String key, String message) {
        String encrypted = "";
        try {
            byte[] keyArray = Base64.decodeBase64((byte[])key.getBytes());
            SecretKeySpec skeySpec = new SecretKeySpec(keyArray, "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(1, skeySpec);
            byte[] encrypt = cipher.doFinal(message.getBytes());
            encrypted = new String(hexCodec.encode(encrypt));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        return encrypted;
    }

    public static String encryptBase64(String key, String message) {
        String encrypted = "";
        try {
            byte[] keyArray = Base64.decodeBase64((byte[])key.getBytes());
            SecretKeySpec skeySpec = new SecretKeySpec(keyArray, "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(1, skeySpec);
            byte[] encrypt = cipher.doFinal(message.getBytes());
            encrypted = new String(Base64.encodeBase64((byte[])encrypt));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        return encrypted;
    }

    public static String encrypt(String key, long value) {
        return AesUtils.encrypt(key, String.valueOf(value));
    }

    public static String encrypt(String key, int value) {
        return AesUtils.encrypt(key, String.valueOf(value));
    }

    public static String encrypt(String key, boolean value) {
        return AesUtils.encrypt(key, String.valueOf(value));
    }

    public static String encrypt(String key, char value) {
        return AesUtils.encrypt(key, String.valueOf(value));
    }

    public static String encrypt(String key, byte value) {
        return AesUtils.encrypt(key, String.valueOf(value));
    }

    public static String encrypt(String key, float value) {
        return AesUtils.encrypt(key, String.valueOf(value));
    }

    public static String encrypt(String key, double value) {
        return AesUtils.encrypt(key, String.valueOf(value));
    }

    public static String encryptBase64(String key, long value) {
        return AesUtils.encryptBase64(key, String.valueOf(value));
    }

    public static String encryptBase64(String key, int value) {
        return AesUtils.encryptBase64(key, String.valueOf(value));
    }

    public static String encryptBase64(String key, boolean value) {
        return AesUtils.encryptBase64(key, String.valueOf(value));
    }

    public static String encryptBase64(String key, char value) {
        return AesUtils.encryptBase64(key, String.valueOf(value));
    }

    public static String encryptBase64(String key, byte value) {
        return AesUtils.encryptBase64(key, String.valueOf(value));
    }

    public static String encryptBase64(String key, float value) {
        return AesUtils.encryptBase64(key, String.valueOf(value));
    }

    public static String encryptBase64(String key, double value) {
        return AesUtils.encryptBase64(key, String.valueOf(value));
    }

    public static String decrypt(String key, String value) {
        String decrypted = "";
        try {
            byte[] keyArray = Base64.decodeBase64((byte[])key.getBytes());
            SecretKeySpec skeySpec = new SecretKeySpec(keyArray, "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(2, skeySpec);
            byte[] encrypted = hexCodec.decode(value.getBytes());
            byte[] original = cipher.doFinal(encrypted);
            decrypted = new String(original);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            decrypted = "";
        }
        return decrypted;
    }

    public static String decryptBase64(String key, String value) {
        String decrypted = "";
        try {
            byte[] keyArray = Base64.decodeBase64((byte[])key.getBytes());
            SecretKeySpec skeySpec = new SecretKeySpec(keyArray, "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(2, skeySpec);
            byte[] encrypted = Base64.decodeBase64((byte[])value.getBytes());
            byte[] original = cipher.doFinal(encrypted);
            decrypted = new String(original);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            decrypted = "";
        }
        return decrypted;
    }

    public static String decrypt(String value) {
        String key = AesUtils.getEnryptionKey();
        if (logger.isDebugEnabled()) {
            logger.debug("key: " + key);
            logger.debug("encrypted message: " + value);
        }
        return AesUtils.decrypt(key, value);
    }

    public static String decryptBase64(String value) {
        String key = AesUtils.getEnryptionKey();
        if (logger.isDebugEnabled()) {
            logger.debug("key: " + key);
            logger.debug("encrypted message: " + value);
        }
        return AesUtils.decryptBase64(key, value);
    }
}

