/*
 * Decompiled with CFR 0.152.
 */
package org.yestech.lib.crypto;

import java.util.Random;

class MD5Crypt {
    MD5Crypt() {
    }

    private static final String to64(long v, int size) {
        StringBuffer result = new StringBuffer();
        while (--size >= 0) {
            result.append("./0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".charAt((int)(v & 0x3FL)));
            v >>>= 6;
        }
        return result.toString();
    }

    private static final void clearbits(byte[] bits) {
        for (int i = 0; i < bits.length; ++i) {
            bits[i] = 0;
        }
    }

    private static final int bytes2u(byte inp) {
        return inp & 0xFF;
    }

    public static final String crypt(String password) {
        StringBuffer salt = new StringBuffer();
        Random randgen = new Random();
        while (salt.length() < 8) {
            int index = (int)(randgen.nextFloat() * (float)"abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890".length());
            salt.append("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890".substring(index, index + 1));
        }
        return MD5Crypt.crypt(password, salt.toString());
    }

    public static final String crypt(String password, String salt) {
        return MD5Crypt.crypt(password, salt, "$1$");
    }

    public static final String apacheCrypt(String password) {
        StringBuffer salt = new StringBuffer();
        Random randgen = new Random();
        while (salt.length() < 8) {
            int index = (int)(randgen.nextFloat() * (float)"abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890".length());
            salt.append("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890".substring(index, index + 1));
        }
        return MD5Crypt.apacheCrypt(password, salt.toString());
    }

    public static final String apacheCrypt(String password, String salt) {
        return MD5Crypt.crypt(password, salt, "$apr1$");
    }

    public static final String crypt(String password, String salt, String magic) {
        int i;
        if (salt.startsWith(magic)) {
            salt = salt.substring(magic.length());
        }
        if (salt.indexOf(36) != -1) {
            salt = salt.substring(0, salt.indexOf(36));
        }
        if (salt.length() > 8) {
            salt = salt.substring(0, 8);
        }
        MD5 ctx = new MD5();
        ctx.Update(password);
        ctx.Update(magic);
        ctx.Update(salt);
        MD5 ctx1 = new MD5();
        ctx1.Update(password);
        ctx1.Update(salt);
        ctx1.Update(password);
        byte[] finalState = ctx1.Final();
        for (int pl = password.length(); pl > 0; pl -= 16) {
            ctx.Update(finalState, pl > 16 ? 16 : pl);
        }
        MD5Crypt.clearbits(finalState);
        for (i = password.length(); i != 0; i >>>= 1) {
            if ((i & 1) != 0) {
                ctx.Update(finalState, 1);
                continue;
            }
            ctx.Update(password.getBytes(), 1);
        }
        finalState = ctx.Final();
        for (i = 0; i < 1000; ++i) {
            ctx1 = new MD5();
            if ((i & 1) != 0) {
                ctx1.Update(password);
            } else {
                ctx1.Update(finalState, 16);
            }
            if (i % 3 != 0) {
                ctx1.Update(salt);
            }
            if (i % 7 != 0) {
                ctx1.Update(password);
            }
            if ((i & 1) != 0) {
                ctx1.Update(finalState, 16);
            } else {
                ctx1.Update(password);
            }
            finalState = ctx1.Final();
        }
        StringBuffer result = new StringBuffer();
        result.append(magic);
        result.append(salt);
        result.append("$");
        long l = MD5Crypt.bytes2u(finalState[0]) << 16 | MD5Crypt.bytes2u(finalState[6]) << 8 | MD5Crypt.bytes2u(finalState[12]);
        result.append(MD5Crypt.to64(l, 4));
        l = MD5Crypt.bytes2u(finalState[1]) << 16 | MD5Crypt.bytes2u(finalState[7]) << 8 | MD5Crypt.bytes2u(finalState[13]);
        result.append(MD5Crypt.to64(l, 4));
        l = MD5Crypt.bytes2u(finalState[2]) << 16 | MD5Crypt.bytes2u(finalState[8]) << 8 | MD5Crypt.bytes2u(finalState[14]);
        result.append(MD5Crypt.to64(l, 4));
        l = MD5Crypt.bytes2u(finalState[3]) << 16 | MD5Crypt.bytes2u(finalState[9]) << 8 | MD5Crypt.bytes2u(finalState[15]);
        result.append(MD5Crypt.to64(l, 4));
        l = MD5Crypt.bytes2u(finalState[4]) << 16 | MD5Crypt.bytes2u(finalState[10]) << 8 | MD5Crypt.bytes2u(finalState[5]);
        result.append(MD5Crypt.to64(l, 4));
        l = MD5Crypt.bytes2u(finalState[11]);
        result.append(MD5Crypt.to64(l, 2));
        MD5Crypt.clearbits(finalState);
        return result.toString();
    }

    static class MD5State {
        int[] state;
        int[] count;
        byte[] buffer = new byte[64];

        public MD5State() {
            this.count = new int[2];
            this.state = new int[4];
            this.state[0] = 1732584193;
            this.state[1] = -271733879;
            this.state[2] = -1732584194;
            this.state[3] = 271733878;
            this.count[1] = 0;
            this.count[0] = 0;
        }

        MD5State(MD5State from) {
            this();
            int i;
            for (i = 0; i < this.buffer.length; ++i) {
                this.buffer[i] = from.buffer[i];
            }
            for (i = 0; i < this.state.length; ++i) {
                this.state[i] = from.state[i];
            }
            for (i = 0; i < this.count.length; ++i) {
                this.count[i] = from.count[i];
            }
        }
    }

    private static class MD5 {
        MD5State state;
        MD5State finals;
        static byte[] padding = new byte[]{-128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

        public synchronized void Init() {
            this.state = new MD5State();
            this.finals = null;
        }

        public MD5() {
            this.Init();
        }

        public MD5(Object ob) {
            this();
            this.Update(ob.toString());
        }

        public String debugDump() {
            return this.asHex();
        }

        private int rotate_left(int x, int n) {
            return x << n | x >>> 32 - n;
        }

        private int uadd(int a, int b) {
            long aa = (long)a & 0xFFFFFFFFL;
            long bb = (long)b & 0xFFFFFFFFL;
            return (int)((aa += bb) & 0xFFFFFFFFL);
        }

        private int uadd(int a, int b, int c) {
            return this.uadd(this.uadd(a, b), c);
        }

        private int uadd(int a, int b, int c, int d) {
            return this.uadd(this.uadd(a, b, c), d);
        }

        private int FF(int a, int b, int c, int d, int x, int s, int ac) {
            a = this.uadd(a, b & c | ~b & d, x, ac);
            return this.uadd(this.rotate_left(a, s), b);
        }

        private int GG(int a, int b, int c, int d, int x, int s, int ac) {
            a = this.uadd(a, b & d | c & ~d, x, ac);
            return this.uadd(this.rotate_left(a, s), b);
        }

        private int HH(int a, int b, int c, int d, int x, int s, int ac) {
            a = this.uadd(a, b ^ c ^ d, x, ac);
            return this.uadd(this.rotate_left(a, s), b);
        }

        private int II(int a, int b, int c, int d, int x, int s, int ac) {
            a = this.uadd(a, c ^ (b | ~d), x, ac);
            return this.uadd(this.rotate_left(a, s), b);
        }

        private int[] Decode(byte[] buffer, int len, int shift) {
            int[] out = new int[16];
            int i = 0;
            for (int j = 0; j < len; j += 4) {
                out[i] = buffer[j + shift] & 0xFF | (buffer[j + 1 + shift] & 0xFF) << 8 | (buffer[j + 2 + shift] & 0xFF) << 16 | (buffer[j + 3 + shift] & 0xFF) << 24;
                ++i;
            }
            return out;
        }

        private void Transform(MD5State state, byte[] buffer, int shift) {
            int a = state.state[0];
            int b = state.state[1];
            int c = state.state[2];
            int d = state.state[3];
            int[] x = this.Decode(buffer, 64, shift);
            a = this.FF(a, b, c, d, x[0], 7, -680876936);
            d = this.FF(d, a, b, c, x[1], 12, -389564586);
            c = this.FF(c, d, a, b, x[2], 17, 606105819);
            b = this.FF(b, c, d, a, x[3], 22, -1044525330);
            a = this.FF(a, b, c, d, x[4], 7, -176418897);
            d = this.FF(d, a, b, c, x[5], 12, 1200080426);
            c = this.FF(c, d, a, b, x[6], 17, -1473231341);
            b = this.FF(b, c, d, a, x[7], 22, -45705983);
            a = this.FF(a, b, c, d, x[8], 7, 1770035416);
            d = this.FF(d, a, b, c, x[9], 12, -1958414417);
            c = this.FF(c, d, a, b, x[10], 17, -42063);
            b = this.FF(b, c, d, a, x[11], 22, -1990404162);
            a = this.FF(a, b, c, d, x[12], 7, 1804603682);
            d = this.FF(d, a, b, c, x[13], 12, -40341101);
            c = this.FF(c, d, a, b, x[14], 17, -1502002290);
            b = this.FF(b, c, d, a, x[15], 22, 1236535329);
            a = this.GG(a, b, c, d, x[1], 5, -165796510);
            d = this.GG(d, a, b, c, x[6], 9, -1069501632);
            c = this.GG(c, d, a, b, x[11], 14, 643717713);
            b = this.GG(b, c, d, a, x[0], 20, -373897302);
            a = this.GG(a, b, c, d, x[5], 5, -701558691);
            d = this.GG(d, a, b, c, x[10], 9, 38016083);
            c = this.GG(c, d, a, b, x[15], 14, -660478335);
            b = this.GG(b, c, d, a, x[4], 20, -405537848);
            a = this.GG(a, b, c, d, x[9], 5, 568446438);
            d = this.GG(d, a, b, c, x[14], 9, -1019803690);
            c = this.GG(c, d, a, b, x[3], 14, -187363961);
            b = this.GG(b, c, d, a, x[8], 20, 1163531501);
            a = this.GG(a, b, c, d, x[13], 5, -1444681467);
            d = this.GG(d, a, b, c, x[2], 9, -51403784);
            c = this.GG(c, d, a, b, x[7], 14, 1735328473);
            b = this.GG(b, c, d, a, x[12], 20, -1926607734);
            a = this.HH(a, b, c, d, x[5], 4, -378558);
            d = this.HH(d, a, b, c, x[8], 11, -2022574463);
            c = this.HH(c, d, a, b, x[11], 16, 1839030562);
            b = this.HH(b, c, d, a, x[14], 23, -35309556);
            a = this.HH(a, b, c, d, x[1], 4, -1530992060);
            d = this.HH(d, a, b, c, x[4], 11, 1272893353);
            c = this.HH(c, d, a, b, x[7], 16, -155497632);
            b = this.HH(b, c, d, a, x[10], 23, -1094730640);
            a = this.HH(a, b, c, d, x[13], 4, 681279174);
            d = this.HH(d, a, b, c, x[0], 11, -358537222);
            c = this.HH(c, d, a, b, x[3], 16, -722521979);
            b = this.HH(b, c, d, a, x[6], 23, 76029189);
            a = this.HH(a, b, c, d, x[9], 4, -640364487);
            d = this.HH(d, a, b, c, x[12], 11, -421815835);
            c = this.HH(c, d, a, b, x[15], 16, 530742520);
            b = this.HH(b, c, d, a, x[2], 23, -995338651);
            a = this.II(a, b, c, d, x[0], 6, -198630844);
            d = this.II(d, a, b, c, x[7], 10, 1126891415);
            c = this.II(c, d, a, b, x[14], 15, -1416354905);
            b = this.II(b, c, d, a, x[5], 21, -57434055);
            a = this.II(a, b, c, d, x[12], 6, 1700485571);
            d = this.II(d, a, b, c, x[3], 10, -1894986606);
            c = this.II(c, d, a, b, x[10], 15, -1051523);
            b = this.II(b, c, d, a, x[1], 21, -2054922799);
            a = this.II(a, b, c, d, x[8], 6, 1873313359);
            d = this.II(d, a, b, c, x[15], 10, -30611744);
            c = this.II(c, d, a, b, x[6], 15, -1560198380);
            b = this.II(b, c, d, a, x[13], 21, 1309151649);
            a = this.II(a, b, c, d, x[4], 6, -145523070);
            d = this.II(d, a, b, c, x[11], 10, -1120210379);
            c = this.II(c, d, a, b, x[2], 15, 718787259);
            b = this.II(b, c, d, a, x[9], 21, -343485551);
            state.state[0] = state.state[0] + a;
            state.state[1] = state.state[1] + b;
            state.state[2] = state.state[2] + c;
            state.state[3] = state.state[3] + d;
        }

        public void Update(MD5State state, byte[] buffer, int offset, int length) {
            int i;
            this.finals = null;
            if (length - offset > buffer.length) {
                length = buffer.length - offset;
            }
            int index = state.count[0] >>> 3 & 0x3F;
            state.count[0] = state.count[0] + (length << 3);
            if (state.count[0] < length << 3) {
                state.count[1] = state.count[1] + 1;
            }
            state.count[1] = state.count[1] + (length >>> 29);
            int partlen = 64 - index;
            if (length >= partlen) {
                for (i = 0; i < partlen; ++i) {
                    state.buffer[i + index] = buffer[i + offset];
                }
                this.Transform(state, state.buffer, 0);
                i = partlen;
                while (i + 63 < length) {
                    this.Transform(state, buffer, i);
                    i += 64;
                }
                index = 0;
            } else {
                i = 0;
            }
            if (i < length) {
                int start = i;
                while (i < length) {
                    state.buffer[index + i - start] = buffer[i + offset];
                    ++i;
                }
            }
        }

        public void Update(byte[] buffer, int offset, int length) {
            this.Update(this.state, buffer, offset, length);
        }

        public void Update(byte[] buffer, int length) {
            this.Update(this.state, buffer, 0, length);
        }

        public void Update(byte[] buffer) {
            this.Update(buffer, 0, buffer.length);
        }

        public void Update(byte b) {
            byte[] buffer = new byte[]{b};
            this.Update(buffer, 1);
        }

        public void Update(String s) {
            byte[] chars = s.getBytes();
            this.Update(chars, chars.length);
        }

        private byte[] Encode(int[] input, int len) {
            byte[] out = new byte[len];
            int i = 0;
            for (int j = 0; j < len; j += 4) {
                out[j] = (byte)(input[i] & 0xFF);
                out[j + 1] = (byte)(input[i] >>> 8 & 0xFF);
                out[j + 2] = (byte)(input[i] >>> 16 & 0xFF);
                out[j + 3] = (byte)(input[i] >>> 24 & 0xFF);
                ++i;
            }
            return out;
        }

        public synchronized byte[] Final() {
            if (this.finals == null) {
                MD5State fin = new MD5State(this.state);
                byte[] bits = this.Encode(fin.count, 8);
                int index = fin.count[0] >>> 3 & 0x3F;
                int padlen = index < 56 ? 56 - index : 120 - index;
                this.Update(fin, padding, 0, padlen);
                this.Update(fin, bits, 0, 8);
                this.finals = fin;
            }
            return this.Encode(this.finals.state, 16);
        }

        public static String asHex(byte[] hash) {
            StringBuffer buf = new StringBuffer(hash.length * 2);
            for (int i = 0; i < hash.length; ++i) {
                if ((hash[i] & 0xFF) < 16) {
                    buf.append("0");
                }
                buf.append(Long.toString(hash[i] & 0xFF, 16));
            }
            return buf.toString();
        }

        public String asHex() {
            return MD5.asHex(this.Final());
        }

        public static String md5crypt(String input) {
            MD5 md5 = new MD5();
            md5.Init();
            md5.Update(input);
            return md5.asHex();
        }
    }
}

