/*
 * Decompiled with CFR 0.152.
 */
package org.yestech.lib.crypto;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.security.MessageDigest;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageDigestUtils {
    private static final Logger logger = LoggerFactory.getLogger(MessageDigestUtils.class);
    private static final Hex hexCodec = new Hex();

    private MessageDigestUtils() {
    }

    public static String md5Hash(String arg) {
        if (arg != null) {
            return DigestUtils.md5Hex((String)arg);
        }
        return "";
    }

    public static String md5Hash(File file) {
        if (file == null) {
            return null;
        }
        try {
            return MessageDigestUtils.md5Hash(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static String md5Hash(InputStream stream) {
        if (stream == null) {
            return null;
        }
        BufferedInputStream bis = new BufferedInputStream(stream);
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] buffer = new byte[16384];
            int bytesRead = -1;
            while ((bytesRead = bis.read(buffer, 0, buffer.length)) != -1) {
                messageDigest.update(buffer, 0, bytesRead);
            }
            String string = new String(Hex.encodeHex((byte[])messageDigest.digest()));
            return string;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)bis);
        }
    }

    public static String md5Hash(byte[] barray) {
        return DigestUtils.md5Hex((byte[])barray);
    }

    public static String sha1Hash(File file) {
        if (file == null) {
            return null;
        }
        try {
            return MessageDigestUtils.sha1Hash(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static String sha1Hash(InputStream stream) {
        if (stream == null) {
            return null;
        }
        BufferedInputStream bis = new BufferedInputStream(stream);
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
            byte[] buffer = new byte[16384];
            int bytesRead = -1;
            while ((bytesRead = bis.read(buffer, 0, buffer.length)) != -1) {
                messageDigest.update(buffer, 0, bytesRead);
            }
            String string = new String(Hex.encodeHex((byte[])messageDigest.digest()));
            return string;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)bis);
        }
    }

    public static String sha1Hash(String arg) {
        if (arg != null) {
            return DigestUtils.shaHex((String)arg);
        }
        return "";
    }

    public static String sha1Hash(byte[] barray) {
        return DigestUtils.shaHex((byte[])barray);
    }
}

