/*
 * Decompiled with CFR 0.152.
 */
package org.yestech.lib.crypto;

import java.util.HashMap;
import java.util.Map;
import org.yestech.lib.crypto.ApacheConversionFactory;
import org.yestech.lib.crypto.IPasswordConversionFactory;
import org.yestech.lib.crypto.PasswordTypeEnum;
import org.yestech.lib.crypto.UPortalConversionFactory;
import org.yestech.lib.crypto.UnixCryptConversionFactory;
import org.yestech.lib.crypto.UnixMd5ConversionFactory;

public class PasswordConversion {
    private static final Map<PasswordTypeEnum, IPasswordConversionFactory> convertors = new HashMap<PasswordTypeEnum, IPasswordConversionFactory>();

    public static String convert(PasswordTypeEnum type, String password, Object ... params) {
        String convertedPassword = null;
        IPasswordConversionFactory convertor = convertors.get((Object)type);
        if (convertor != null) {
            convertedPassword = convertor.transform(password, params);
        }
        return convertedPassword;
    }

    static {
        convertors.put(PasswordTypeEnum.UNIX_CRYPT, new UnixCryptConversionFactory());
        convertors.put(PasswordTypeEnum.UNIX_MD5, new UnixMd5ConversionFactory());
        convertors.put(PasswordTypeEnum.APACHE, new ApacheConversionFactory());
        convertors.put(PasswordTypeEnum.UPORTAL, new UPortalConversionFactory());
    }
}

