/*
 * Decompiled with CFR 0.152.
 */
package org.yestech.lib.crypto;

import java.security.SecureRandom;
import org.yestech.lib.crypto.ICryptoConstants;

public class PasswordGenerator {
    public static String createPassword() {
        return PasswordGenerator.createPassword(10);
    }

    private static byte[] generatePassword(int len) {
        StringBuilder buf = new StringBuilder();
        SecureRandom random = new SecureRandom();
        SecureRandom randomType = new SecureRandom();
        block5: for (int i = 0; i < len; ++i) {
            int type = randomType.nextInt(3);
            switch (type) {
                case 0: {
                    buf.append(ICryptoConstants.UPPER_ALPHABET[random.nextInt(26)]);
                    continue block5;
                }
                case 1: {
                    int num = random.nextInt(9);
                    buf.append(++num);
                    continue block5;
                }
                case 2: {
                    buf.append(ICryptoConstants.LOWER_ALPHABET[random.nextInt(26)]);
                }
            }
        }
        return buf.toString().getBytes();
    }

    public static String createPassword(int len) {
        if (len < 1) {
            throw new IllegalArgumentException("min length must be atleast 1");
        }
        return new String(PasswordGenerator.generatePassword(len));
    }
}

