/*
 * Decompiled with CFR 0.152.
 */
package org.yestech.lib.crypto;

import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Date;
import org.yestech.lib.crypto.IPasswordConversionFactory;

public class UPortalConversionFactory
implements IPasswordConversionFactory {
    @Override
    public String transform(String password, Object ... params) {
        SecureRandom r;
        MessageDigest md;
        byte[] rnd = new byte[8];
        byte[] fin = new byte[24];
        try {
            md = MessageDigest.getInstance("MD5");
            Long date = new Long(new Date().getTime());
            r = new SecureRandom(date.toString().getBytes());
        }
        catch (Exception e) {
            throw new RuntimeException("Error getting instance...", e);
        }
        r.nextBytes(rnd);
        md.update(rnd);
        byte[] hash = md.digest(password.getBytes());
        System.arraycopy(rnd, 0, fin, 0, 8);
        System.arraycopy(hash, 0, fin, 8, 16);
        return "(MD5)" + UPortalConversionFactory.encode(fin);
    }

    private static String encode(byte[] raw) {
        StringBuffer encoded = new StringBuffer();
        for (int i = 0; i < raw.length; i += 3) {
            encoded.append(UPortalConversionFactory.encodeBlock(raw, i));
        }
        return encoded.toString();
    }

    private static char[] encodeBlock(byte[] raw, int offset) {
        int block = 0;
        int slack = raw.length - offset - 1;
        int end = slack >= 2 ? 2 : slack;
        for (int i = 0; i <= end; ++i) {
            int b = raw[offset + i];
            int neuter = b < 0 ? b + 256 : b;
            block += neuter << 8 * (2 - i);
        }
        char[] base64 = new char[4];
        for (int i = 0; i < 4; ++i) {
            int sixbit = block >>> 6 * (3 - i) & 0x3F;
            base64[i] = UPortalConversionFactory.getChar(sixbit);
        }
        if (slack < 1) {
            base64[2] = 61;
        }
        if (slack < 2) {
            base64[3] = 61;
        }
        return base64;
    }

    private static char getChar(int sixBit) {
        if (sixBit >= 0 && sixBit <= 25) {
            return (char)(65 + sixBit);
        }
        if (sixBit >= 26 && sixBit <= 51) {
            return (char)(97 + (sixBit - 26));
        }
        if (sixBit >= 52 && sixBit <= 61) {
            return (char)(48 + (sixBit - 52));
        }
        if (sixBit == 62) {
            return '+';
        }
        if (sixBit == 63) {
            return '/';
        }
        return '?';
    }
}

