/*
 * Decompiled with CFR 0.152.
 */
package org.yestech.lib.currency;

import java.math.BigDecimal;
import org.yestech.lib.currency.CurrencyException;
import org.yestech.lib.currency.Money;

public class CurrencyUtils {
    public static Money add(Money leftSide, Money rightSide) {
        Money addition = null;
        CurrencyUtils.validationCheck(leftSide, rightSide);
        addition = new Money(leftSide.getAmount().add(rightSide.getAmount()), leftSide.getLocale());
        return addition;
    }

    public static Money subtract(Money leftSide, Money rightSide) {
        Money addition = null;
        CurrencyUtils.validationCheck(leftSide, rightSide);
        addition = new Money(leftSide.getAmount().subtract(rightSide.getAmount()), leftSide.getLocale());
        return addition;
    }

    public static Money divide(Money leftSide, Money rightSide) {
        Money addition = null;
        CurrencyUtils.validationCheck(leftSide, rightSide);
        CurrencyUtils.divideByZeroCheck(rightSide);
        addition = new Money(leftSide.getAmount().divide(rightSide.getAmount()), leftSide.getLocale());
        return addition;
    }

    public static Money divide(Money leftSide, Money rightSide, int roundMode) {
        Money addition = null;
        CurrencyUtils.validationCheck(leftSide, rightSide);
        CurrencyUtils.divideByZeroCheck(rightSide);
        addition = new Money(leftSide.getAmount().divide(rightSide.getAmount(), roundMode), leftSide.getLocale());
        return addition;
    }

    private static void divideByZeroCheck(Money rightSide) {
        if (rightSide.getAmount().equals(BigDecimal.ZERO)) {
            throw new CurrencyException("cant divide by zero");
        }
    }

    public static Money multiple(Money leftSide, Money rightSide) {
        Money addition = null;
        CurrencyUtils.validationCheck(leftSide, rightSide);
        addition = new Money(leftSide.getAmount().multiply(rightSide.getAmount()), leftSide.getLocale());
        return addition;
    }

    private static void validationCheck(Money leftSide, Money rightSide) {
        if (leftSide == null || rightSide == null) {
            throw new CurrencyException("cant add null value");
        }
        if (!leftSide.getCurreny().equals(rightSide.getCurreny())) {
            throw new CurrencyException("cant add two values that dont have the same currency");
        }
    }
}

