/*
 * Decompiled with CFR 0.152.
 */
package org.yestech.lib.currency;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Currency;
import java.util.Locale;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.yestech.lib.currency.CurrencyException;

@XStreamAlias(value="money")
@XmlRootElement(name="money")
public class Money
implements Serializable,
Comparable<Money> {
    private BigDecimal amount = BigDecimal.ZERO;
    private Locale locale;
    private Currency curreny;

    public Money() {
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void setCurreny(Currency curreny) {
        this.curreny = curreny;
    }

    public Money(double amount) {
        this(amount, Locale.US);
    }

    public Money(double amount, Locale locale) {
        if (amount < 0.0) {
            throw new CurrencyException("money amount must be a positive number");
        }
        if (locale == null) {
            throw new CurrencyException("can't have a null locale");
        }
        this.amount = new BigDecimal(amount);
        this.locale = locale;
        this.curreny = Currency.getInstance(locale);
    }

    public Money(String amount) {
        this(amount, Locale.US);
    }

    public Money(String amount, Locale locale) {
        if (StringUtils.isBlank((String)amount) || !NumberUtils.isNumber((String)amount)) {
            throw new CurrencyException("money amount must be a positive number");
        }
        BigDecimal tmpAmount = new BigDecimal(amount);
        this.validateAmount(tmpAmount);
        if (locale == null) {
            throw new CurrencyException("can't have a null locale");
        }
        this.amount = tmpAmount;
        this.locale = locale;
        this.curreny = Currency.getInstance(locale);
    }

    public Money(BigDecimal amount) {
        this(amount, Locale.US);
    }

    public Money(BigDecimal amount, Locale locale) {
        this.validateAmount(amount);
        if (locale == null) {
            throw new CurrencyException("can't have a null locale");
        }
        this.amount = amount;
        this.locale = locale;
        this.curreny = Currency.getInstance(locale);
    }

    private void validateAmount(BigDecimal amount) {
        if (amount == null || amount.doubleValue() < BigDecimal.ZERO.doubleValue()) {
            throw new CurrencyException("can't have a null of negative money amount");
        }
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public Currency getCurreny() {
        return this.curreny;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Money)) {
            return false;
        }
        Money money = (Money)o;
        if (this.amount != null ? !this.amount.equals(money.amount) : money.amount != null) {
            return false;
        }
        if (this.curreny != null ? !this.curreny.equals(money.curreny) : money.curreny != null) {
            return false;
        }
        return !(this.locale != null ? !this.locale.equals(money.locale) : money.locale != null);
    }

    public int hashCode() {
        int result = this.amount != null ? this.amount.hashCode() : 0;
        result = 31 * result + (this.locale != null ? this.locale.hashCode() : 0);
        result = 31 * result + (this.curreny != null ? this.curreny.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Money{amount=" + this.amount + ", locale=" + this.locale + ", curreny=" + this.curreny + '}';
    }

    @Override
    public int compareTo(Money comparable) {
        return this.getAmount().compareTo(comparable.getAmount());
    }
}

