/*
 * Decompiled with CFR 0.152.
 */
package org.yestech.lib.hessian.currency;

import com.caucho.hessian.io.AbstractDeserializer;
import com.caucho.hessian.io.AbstractHessianInput;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.yestech.lib.currency.Money;

public class MoneyDeserializer
extends AbstractDeserializer {
    public Class getType() {
        return Money.class;
    }

    public Object readMap(AbstractHessianInput in) throws IOException {
        int ref = in.addRef(null);
        String amount = null;
        String locale = null;
        while (!in.isEnd()) {
            String key = in.readString();
            if (key.equals("value")) {
                amount = in.readString();
            }
            if (key.equals("locale")) {
                locale = in.readString();
                continue;
            }
            in.readString();
        }
        in.readMapEnd();
        String[] localeSplit = StringUtils.split(locale, (String)":");
        Money value = new Money(new BigDecimal(amount), new Locale(localeSplit[0], localeSplit[1]));
        in.setRef(ref, (Object)value);
        return value;
    }

    public Object readObject(AbstractHessianInput in, String[] fieldNames) throws IOException {
        int ref = in.addRef(null);
        String amount = null;
        String locale = null;
        for (String key : fieldNames) {
            if (key.equals("value")) {
                amount = in.readString();
            }
            if (key.equals("locale")) {
                locale = in.readString();
                continue;
            }
            in.readObject();
        }
        String[] localeSplit = StringUtils.split(locale, (String)":");
        Money value = new Money(new BigDecimal(amount), new Locale(localeSplit[0], localeSplit[1]));
        in.setRef(ref, (Object)value);
        return value;
    }
}

