/*
 * Decompiled with CFR 0.152.
 */
package org.yestech.lib.hibernate.client;

import java.rmi.RemoteException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.springframework.context.ApplicationContext;
import org.yestech.lib.hibernate.client.HibernateServerRemote;

public class ClientSession {
    private static final ThreadLocal<HibernateServerRemote> REF = new ThreadLocal();
    private static ApplicationContext applicationContext;

    public static void init(ApplicationContext applicationContext) {
        ClientSession.applicationContext = applicationContext;
    }

    private static void start() throws ClassCastException, NamingException, RemoteException {
        if (ClientSession.isActive()) {
            throw new IllegalStateException("nested sessions are not supported");
        }
        HibernateServerRemote home = (HibernateServerRemote)applicationContext.getBean("hibernateServer");
        REF.set(home);
    }

    private static boolean isActive() {
        return REF.get() != null;
    }

    static HibernateServerRemote getLoader() {
        if (!ClientSession.isActive()) {
            throw new IllegalStateException("session is not active");
        }
        return REF.get();
    }

    private static void release() throws RemoteException {
        HibernateServerRemote loader = REF.get();
        if (loader == null) {
            throw new IllegalStateException("session is not started");
        }
        REF.set(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(Runnable cmd) throws Exception {
        InitialContext context = new InitialContext();
        try {
            ClientSession.start();
            try {
                cmd.run();
            }
            finally {
                ClientSession.release();
            }
        }
        finally {
            context.close();
        }
    }
}

