/*
 * Decompiled with CFR 0.152.
 */
package org.yestech.lib.hibernate.client;

import java.io.Serializable;
import java.util.Collection;
import javax.naming.NamingException;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.hibernate.classic.Session;
import org.hibernate.engine.CollectionKey;
import org.hibernate.engine.PersistenceContext;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.proxy.HibernateProxy;
import org.springframework.beans.factory.annotation.Required;
import org.yestech.lib.hibernate.client.HibernateServerRemote;
import org.yestech.lib.hibernate.client.RemotableSetType;

public class HibernateServerBean
implements HibernateServerRemote,
Serializable {
    private static final long serialVersionUID = -3354876500675131726L;
    private SessionFactory factory;

    @Override
    public Object initializeEntity(String className, Serializable id, int token) throws ClassNotFoundException, HibernateException, NamingException {
        Class<?> cls = Class.forName(className, false, Thread.currentThread().getContextClassLoader());
        Session currentSession = this.factory.getCurrentSession();
        if (System.identityHashCode(currentSession) == token) {
            Object obj = currentSession.get(cls, id);
            if (obj == null) {
                throw new IllegalStateException("object not found " + cls + " " + id);
            }
            return ((HibernateProxy)obj).getHibernateLazyInitializer().getImplementation();
        }
        throw new IllegalStateException("invalid session id");
    }

    @Override
    public Collection initializeCollection(String role, Serializable id) throws ClassNotFoundException, HibernateException, NamingException {
        CollectionPersister persister;
        CollectionKey key;
        PersistenceContext context = ((SessionImplementor)this.factory.getCurrentSession()).getPersistenceContext();
        RemotableSetType.Wrapper col = (RemotableSetType.Wrapper)context.getCollection(key = new CollectionKey(persister = ((SessionFactoryImplementor)this.factory).getCollectionPersister(role), id, EntityMode.POJO));
        if (col == null) {
            throw new IllegalStateException("collection not found");
        }
        return col.unwrapp();
    }

    @Required
    public void setFactory(SessionFactory factory) {
        this.factory = factory;
    }
}

