/*
 * Decompiled with CFR 0.152.
 */
package org.yestech.lib.hibernate.client;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.sf.cglib.core.NamingPolicy;
import net.sf.cglib.core.Predicate;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.CallbackFilter;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.Factory;
import net.sf.cglib.proxy.InvocationHandler;
import net.sf.cglib.proxy.NoOp;
import org.hibernate.HibernateException;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.pojo.BasicLazyInitializer;
import org.hibernate.type.AbstractComponentType;
import org.yestech.lib.hibernate.client.LazyReference;

public class LazyInitializerImpl
extends BasicLazyInitializer
implements InvocationHandler {
    public static final String LOAD_OBJECT_COMMAND = "LO";
    private static final Class[] CALLBACK_TYPES = new Class[]{InvocationHandler.class, NoOp.class};
    private static final CallbackFilter FINALIZE_FILTER = new CallbackFilter(){

        public int accept(Method method) {
            if (method.getParameterTypes().length == 0 && method.getName().equals("finalize")) {
                return 1;
            }
            return 0;
        }
    };

    private LazyInitializerImpl(String entityName, Class persistentClass, Class[] interfaces, Serializable id, Method getIdentifierMethod, Method setIdentifierMethod, AbstractComponentType componentIdType, SessionImplementor session) {
        super(entityName, persistentClass, id, getIdentifierMethod, setIdentifierMethod, componentIdType, session);
    }

    protected Object serializableProxy() {
        if (this.isUninitialized()) {
            LazyReference ref = new LazyReference();
            ref.setClassName(this.getPersistentClass().getName());
            ref.setId(this.getIdentifier());
            ref.setToken(System.identityHashCode(this.getSession()));
            return ref;
        }
        return this.getTarget();
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object result = this.invoke(method, args, proxy);
        if (result == INVOKE_IMPLEMENTATION) {
            Object returnValue;
            Object target = this.getImplementation();
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            try {
                returnValue = method.invoke(target, args);
            }
            catch (InvocationTargetException ite) {
                throw ite.getTargetException();
            }
            return returnValue == target ? proxy : returnValue;
        }
        return result;
    }

    public static Class getProxyFactory(final Class persistentClass, Class[] interfaces) {
        Enhancer en = new Enhancer();
        en.setUseCache(false);
        en.setCallbackTypes(CALLBACK_TYPES);
        en.setCallbackFilter(FINALIZE_FILTER);
        en.setSuperclass(interfaces.length == 1 ? persistentClass : null);
        en.setInterfaces(interfaces);
        en.setNamingPolicy(new NamingPolicy(){

            public String getClassName(String arg0, String arg1, Object arg2, Predicate arg3) {
                return persistentClass.getName() + "$ServerProxy";
            }
        });
        return en.createClass();
    }

    public static HibernateProxy getProxy(Class factory, String entityName, Class persistentClass, Class[] interfaces, Method getIdentifierMethod, Method setIdentifierMethod, AbstractComponentType componentIdType, Serializable id, SessionImplementor session) throws HibernateException {
        HibernateProxy proxy;
        LazyInitializerImpl instance = new LazyInitializerImpl(entityName, persistentClass, interfaces, id, getIdentifierMethod, setIdentifierMethod, componentIdType, session);
        try {
            proxy = (HibernateProxy)factory.newInstance();
        }
        catch (Exception e) {
            throw new HibernateException("CGLIB Enhancement failed: " + persistentClass.getName(), (Throwable)e);
        }
        ((Factory)proxy).setCallback(0, (Callback)instance);
        return proxy;
    }
}

