/*
 * Decompiled with CFR 0.152.
 */
package org.yestech.lib.hibernate.client;

import java.io.ObjectStreamException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import net.sf.cglib.core.NamingPolicy;
import net.sf.cglib.core.Predicate;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.CallbackFilter;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.InvocationHandler;
import net.sf.cglib.proxy.NoOp;
import org.yestech.lib.hibernate.client.ClientSession;
import org.yestech.lib.hibernate.client.CollectionReference;
import org.yestech.lib.hibernate.client.LazyReference;

public class Proxy {
    private static final Class[] CALLBACK_TYPES = new Class[]{InvocationHandler.class, NoOp.class};

    public static Object create(final LazyReference ref) throws ClassNotFoundException {
        Class<?> cls = Class.forName(ref.getClassName(), false, Thread.currentThread().getContextClassLoader());
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(cls);
        enhancer.setCallbackTypes(CALLBACK_TYPES);
        enhancer.setInterfaces(new Class[]{WriteReplace.class});
        enhancer.setCallbackFilter(new CallbackFilter(){

            public int accept(Method m) {
                return Modifier.isPublic(m.getModifiers()) ? 0 : 1;
            }
        });
        enhancer.setCallbacks(new Callback[]{new Interceptor(ref), NoOp.INSTANCE});
        enhancer.setNamingPolicy(new NamingPolicy(){

            public String getClassName(String arg0, String arg1, Object arg2, Predicate arg3) {
                return ref.getClassName() + "$ClientProxy";
            }
        });
        return enhancer.create();
    }

    public static Set create(CollectionReference reference) {
        CollectionProxy set = new CollectionProxy(reference);
        return Collections.unmodifiableSet(set);
    }

    private static final class Interceptor
    implements InvocationHandler {
        private Object entity;
        private LazyReference ref;

        Interceptor(LazyReference ref) {
            this.ref = ref;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (args.length == 0 && method.getDeclaringClass() == WriteReplace.class && method.getName().equals("writeReplace")) {
                if (this.entity != null) {
                    return this.entity;
                }
                return this.ref;
            }
            if (this.entity == null) {
                this.entity = ClientSession.getLoader().initializeEntity(this.ref.getClassName(), this.ref.getId(), this.ref.getToken());
            }
            return method.invoke(this.entity, args);
        }
    }

    public static interface WriteReplace {
        public Object writeReplace() throws ObjectStreamException;
    }

    private static final class CollectionProxy
    extends AbstractSet {
        private final CollectionReference reference;
        private Set remote;

        private CollectionProxy(CollectionReference reference) {
            this.reference = reference;
        }

        Object writeReplare() throws ObjectStreamException {
            if (this.remote != null) {
                return this.remote;
            }
            return this.reference;
        }

        private Set load() {
            try {
                if (this.remote == null) {
                    this.remote = (Set)ClientSession.getLoader().initializeCollection(this.reference.getRole(), this.reference.getId());
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return this.remote;
        }

        @Override
        public int size() {
            return this.load().size();
        }

        @Override
        public boolean isEmpty() {
            return this.load().isEmpty();
        }

        @Override
        public Object[] toArray() {
            return this.load().toArray();
        }

        @Override
        public boolean contains(Object o) {
            return this.load().contains(o);
        }

        @Override
        public boolean containsAll(Collection c) {
            return this.load().containsAll(c);
        }

        @Override
        public Iterator iterator() {
            return this.load().iterator();
        }

        @Override
        public Object[] toArray(Object[] a) {
            return this.load().toArray(a);
        }
    }
}

