/*
 * Decompiled with CFR 0.152.
 */
package org.yestech.lib.hibernate.search;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.queryParser.MultiFieldQueryParser;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.Query;
import org.hibernate.Filter;
import org.hibernate.FlushMode;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.SessionFactory;
import org.hibernate.classic.Session;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.event.EventSource;
import org.hibernate.search.FullTextFilter;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.orm.hibernate3.HibernateAccessor;
import org.springframework.orm.hibernate3.SessionFactoryUtils;
import org.springframework.util.Assert;
import org.yestech.lib.hibernate.search.FilterConfig;
import org.yestech.lib.hibernate.search.HibernateSearchCallback;
import org.yestech.lib.hibernate.search.YesHibernateSearchOperations;

public class YesHibernateSearchTemplate
extends HibernateAccessor
implements YesHibernateSearchOperations {
    private boolean alwaysUseNewSession = false;
    private boolean exposeNativeSession = false;

    public YesHibernateSearchTemplate() {
    }

    public YesHibernateSearchTemplate(SessionFactory sessionFactory) {
        this.setSessionFactory(sessionFactory);
        this.afterPropertiesSet();
    }

    public void setAlwaysUseNewSession(boolean alwaysUseNewSession) {
        this.alwaysUseNewSession = alwaysUseNewSession;
    }

    public boolean isAlwaysUseNewSession() {
        return this.alwaysUseNewSession;
    }

    public void setExposeNativeSession(boolean exposeNativeSession) {
        this.exposeNativeSession = exposeNativeSession;
    }

    public boolean isExposeNativeSession() {
        return this.exposeNativeSession;
    }

    public Object executeWithNativeSession(HibernateSearchCallback action) {
        return this.doExecute(action, false, true);
    }

    @Override
    public Object doExecute(HibernateSearchCallback action, boolean enforceNewSession, boolean enforceNativeSession) throws DataAccessException {
        boolean existingTransaction;
        Assert.notNull((Object)action, (String)"Callback object must not be null");
        org.hibernate.Session session = enforceNewSession ? SessionFactoryUtils.getNewSession((SessionFactory)this.getSessionFactory(), (Interceptor)this.getEntityInterceptor()) : this.getSession();
        boolean bl = existingTransaction = !enforceNewSession && SessionFactoryUtils.isSessionTransactional((org.hibernate.Session)session, (SessionFactory)this.getSessionFactory());
        if (existingTransaction) {
            this.logger.debug((Object)"Found thread-bound Session for HibernateTemplate");
        }
        FlushMode previousFlushMode = null;
        try {
            previousFlushMode = this.applyFlushMode(session, existingTransaction);
            this.enableFilters(session);
            org.hibernate.Session sessionToExpose = enforceNativeSession || this.isExposeNativeSession() ? session : this.createSessionProxy(session);
            Object result = action.doInHibernate(sessionToExpose);
            this.flushIfNecessary(session, existingTransaction);
            Object object = result;
            return object;
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
        finally {
            if (existingTransaction) {
                this.logger.debug((Object)"Not closing pre-bound Hibernate Session after HibernateTemplate");
                this.disableFilters(session);
                if (previousFlushMode != null) {
                    session.setFlushMode(previousFlushMode);
                }
            } else if (this.isAlwaysUseNewSession()) {
                SessionFactoryUtils.closeSession((org.hibernate.Session)session);
            } else if (SessionFactoryUtils.isDeferredCloseActive((SessionFactory)this.getSessionFactory())) {
                SessionFactoryUtils.initDeferredClose((SessionFactory)this.getSessionFactory());
            } else {
                SessionFactoryUtils.closeSession((org.hibernate.Session)session);
            }
        }
    }

    protected org.hibernate.Session createSessionProxy(org.hibernate.Session session) {
        Class mainIfc;
        Class[] sessionIfcs = null;
        Class clazz = mainIfc = session instanceof Session ? Session.class : org.hibernate.Session.class;
        sessionIfcs = session instanceof EventSource ? new Class[]{mainIfc, EventSource.class} : (session instanceof SessionImplementor ? new Class[]{mainIfc, SessionImplementor.class} : new Class[]{mainIfc});
        return (org.hibernate.Session)Proxy.newProxyInstance(session.getClass().getClassLoader(), sessionIfcs, (InvocationHandler)new CloseSuppressingInvocationHandler(session));
    }

    protected org.hibernate.Session getSession() {
        if (this.isAlwaysUseNewSession()) {
            return SessionFactoryUtils.getNewSession((SessionFactory)this.getSessionFactory(), (Interceptor)this.getEntityInterceptor());
        }
        if (SessionFactoryUtils.hasTransactionalSession((SessionFactory)this.getSessionFactory())) {
            return SessionFactoryUtils.getSession((SessionFactory)this.getSessionFactory(), (boolean)false);
        }
        try {
            return this.getSessionFactory().getCurrentSession();
        }
        catch (HibernateException ex) {
            throw new DataAccessResourceFailureException("Could not obtain current Hibernate Session", (Throwable)ex);
        }
    }

    public void initialize(Object proxy) throws DataAccessException {
        try {
            Hibernate.initialize((Object)proxy);
        }
        catch (HibernateException ex) {
            throw SessionFactoryUtils.convertHibernateAccessException((HibernateException)ex);
        }
    }

    public Filter enableFilter(String filterName) throws IllegalStateException {
        org.hibernate.Session session = SessionFactoryUtils.getSession((SessionFactory)this.getSessionFactory(), (boolean)false);
        Filter filter = session.getEnabledFilter(filterName);
        if (filter == null) {
            filter = session.enableFilter(filterName);
        }
        return filter;
    }

    @Override
    public <T> List<T> search(final Query query, final Class<T> searchClass) {
        return (List)this.executeWithNativeSession(new HibernateSearchCallback(){

            @Override
            public Object doInHibernate(org.hibernate.Session session) throws HibernateException {
                FullTextSession fullTextSession = Search.getFullTextSession((org.hibernate.Session)session);
                FullTextQuery hibernateQuery = fullTextSession.createFullTextQuery(query, new Class[]{searchClass});
                return hibernateQuery.list();
            }
        });
    }

    @Override
    public <T> List<T> search(final Query query, final Class ... searchClass) {
        return (List)this.executeWithNativeSession(new HibernateSearchCallback(){

            @Override
            public Object doInHibernate(org.hibernate.Session session) throws HibernateException {
                FullTextSession fullTextSession = Search.getFullTextSession((org.hibernate.Session)session);
                FullTextQuery hibernateQuery = fullTextSession.createFullTextQuery(query, searchClass);
                return hibernateQuery.list();
            }
        });
    }

    @Override
    public <T> List<T> search(final String searchText, final List<FilterConfig> filters, final Class[] classes, final String ... fields) {
        return (List)this.executeWithNativeSession(new HibernateSearchCallback(){

            @Override
            public Object doInHibernate(org.hibernate.Session session) throws HibernateException {
                MultiFieldQueryParser parser = new MultiFieldQueryParser(fields, (Analyzer)new StandardAnalyzer());
                try {
                    Query q = parser.parse(searchText);
                    FullTextSession s = Search.getFullTextSession((org.hibernate.Session)session);
                    FullTextQuery ftq = s.createFullTextQuery(q, classes);
                    for (FilterConfig fc : filters) {
                        FullTextFilter filter = ftq.enableFullTextFilter(fc.getFilterName());
                        for (Map.Entry<String, Object> entry : fc.getParameters().entrySet()) {
                            filter.setParameter(entry.getKey(), entry.getValue());
                        }
                    }
                    return ftq.list();
                }
                catch (ParseException e) {
                    YesHibernateSearchTemplate.this.logger.error((Object)e.getMessage(), (Throwable)e);
                    throw new HibernateException((Throwable)e);
                }
            }
        });
    }

    @Override
    public <T> List<T> search(String searchText, Class<T> searchClass, String ... fields) {
        return this.search(searchText, searchClass, (Analyzer)new StandardAnalyzer(), fields);
    }

    @Override
    public <T> List<T> search(String searchText, Class[] searchClass, String ... fields) {
        return this.search(searchText, searchClass, (Analyzer)new StandardAnalyzer(), fields);
    }

    @Override
    public <T> List<T> search(String searchText, Class<T> searchClass, Analyzer analyzer, String ... fields) {
        Query query;
        MultiFieldQueryParser parser = new MultiFieldQueryParser(fields, analyzer);
        try {
            query = parser.parse(searchText);
        }
        catch (ParseException e) {
            throw new RuntimeException("Error parsing search text: " + searchText, e);
        }
        return this.search(query, searchClass);
    }

    @Override
    public <T> List<T> search(String searchText, Class[] searchClass, Analyzer analyzer, String ... fields) {
        Query query;
        MultiFieldQueryParser parser = new MultiFieldQueryParser(fields, analyzer);
        try {
            query = parser.parse(searchText);
        }
        catch (ParseException e) {
            throw new RuntimeException("Error parsing search text: " + searchText, e);
        }
        return this.search(query, searchClass);
    }

    private class CloseSuppressingInvocationHandler
    implements InvocationHandler {
        private final org.hibernate.Session target;

        public CloseSuppressingInvocationHandler(org.hibernate.Session target) {
            this.target = target;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("equals")) {
                return proxy == args[0] ? Boolean.TRUE : Boolean.FALSE;
            }
            if (method.getName().equals("hashCode")) {
                return new Integer(System.identityHashCode(proxy));
            }
            if (method.getName().equals("close")) {
                return null;
            }
            try {
                Object retVal = method.invoke((Object)this.target, args);
                return retVal;
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }
}

