/*
 * Decompiled with CFR 0.152.
 */
package org.yestech.lib.i18n;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.yestech.lib.i18n.CountryEnum;

public final class PostalCodeUtil {
    private static final Pattern US_LONG;
    private static final Pattern US_SHORT;

    private PostalCodeUtil() {
    }

    public static boolean isValid(String code, CountryEnum countryEnum) {
        if (code == null) {
            return false;
        }
        if (countryEnum == CountryEnum.UNITED_STATES) {
            return PostalCodeUtil.isValidUS(code);
        }
        return false;
    }

    public static boolean isValidUS(String code) {
        if (code == null) {
            return false;
        }
        Matcher matcher = US_SHORT.matcher(code);
        if (matcher.matches()) {
            return true;
        }
        matcher = US_LONG.matcher(code);
        return matcher.matches();
    }

    static {
        US_SHORT = Pattern.compile("[0-9]{5}");
        US_LONG = Pattern.compile("[0-9]{5}\\-[0-9]{4}");
    }
}

