/*
 * Decompiled with CFR 0.152.
 */
package org.yestech.lib.ibatis;

import com.ibatis.sqlmap.engine.cache.CacheController;
import com.ibatis.sqlmap.engine.cache.CacheModel;
import java.io.Serializable;
import java.net.URL;
import java.util.Properties;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EhCacheController
implements CacheController {
    private static final Logger logger = LoggerFactory.getLogger(EhCacheController.class);
    private CacheManager cacheManager;

    public void flush(CacheModel cacheModel) {
        this.getCache(cacheModel).removeAll();
    }

    public Object getObject(CacheModel cacheModel, Object key) {
        Object result = null;
        try {
            Element element = this.getCache(cacheModel).get((Serializable)((Object)key.toString()));
            if (element != null) {
                result = element.getObjectValue();
            }
        }
        catch (Exception e) {
            logger.debug("cache miss, gonna hit ibatis");
        }
        return result;
    }

    public void putObject(CacheModel cacheModel, Object key, Object object) {
        this.getCache(cacheModel).put(new Element((Object)key.toString(), object));
    }

    public Object removeObject(CacheModel cacheModel, Object key) {
        Object result = this.getObject(cacheModel, key.toString());
        this.getCache(cacheModel).remove((Serializable)((Object)key.toString()));
        return result;
    }

    public void setProperties(Properties props) {
        URL url = this.getClass().getResource(props.getProperty("configFile"));
        this.cacheManager = CacheManager.create((URL)url);
    }

    private Cache getCache(CacheModel cacheModel) {
        String cacheName = cacheModel.getId();
        return this.cacheManager.getCache(cacheName);
    }

    public void finalize() {
        if (this.cacheManager != null) {
            this.cacheManager.shutdown();
        }
    }
}

