/*
 * Decompiled with CFR 0.152.
 */
package org.yestech.lib.io;

import java.io.InputStream;
import java.net.URL;

public final class FileLocator {
    private static final String FILE_EXTENSION_DELIMETER = ".";

    private FileLocator() {
    }

    public URL locatePropertiesFile(String file) {
        return this.locateFile(file, "properties");
    }

    public URL locateXMLFile(String file) {
        return this.locateFile(file, "xml");
    }

    public URL locateFile(String file, String extension) {
        return this.getClassLoader().getResource(this.getFileName(file, extension));
    }

    public URL locateFile(String file) {
        return this.locateFile(file, null);
    }

    public InputStream locatePropertiesFileAsStream(String file) {
        return this.locateFileAsStream(file, "properties");
    }

    public InputStream locateXMLFileAsStream(String file) {
        return this.locateFileAsStream(file, "xml");
    }

    public InputStream locateFileAsStream(String file, String extension) {
        return this.getClassLoader().getResourceAsStream(this.getFileName(file, extension));
    }

    public InputStream locateFileAsStream(String file) {
        return this.locateFileAsStream(file, null);
    }

    public static FileLocator getFile() {
        return new FileLocator();
    }

    private String getFileName(String file, String extension) {
        String fileName = file;
        if (extension != null && !extension.startsWith(FILE_EXTENSION_DELIMETER)) {
            fileName = fileName + FILE_EXTENSION_DELIMETER + extension;
        }
        return fileName;
    }

    private ClassLoader getClassLoader() {
        ClassLoader cl = this.getClass().getClassLoader();
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        return cl;
    }
}

