/*
 * Decompiled with CFR 0.152.
 */
package org.yestech.lib.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemFileDownloadFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(FileSystemFileDownloadFilter.class);
    private boolean deleteAfterDownload;
    private File baseDirectory;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.deleteAfterDownload = BooleanUtils.toBoolean((String)StringUtils.defaultString((String)filterConfig.getInitParameter("deleteAfterDownload"), (String)"false"), (String)"true", (String)"false");
        String tempBaseDir = StringUtils.defaultString((String)filterConfig.getInitParameter("baseDirectory"), (String)System.getProperty("java.io.tmpdir"));
        this.baseDirectory = new File(tempBaseDir);
    }

    public boolean isDeleteAfterDownload() {
        return this.deleteAfterDownload;
    }

    public void setDeleteAfterDownload(boolean deleteAfterDownload) {
        this.deleteAfterDownload = deleteAfterDownload;
    }

    public File getBaseDirectory() {
        return this.baseDirectory;
    }

    public void setBaseDirectory(File baseDirectory) {
        this.baseDirectory = baseDirectory;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String fileName = request.getParameter("file");
        FileInputStream inputStream = null;
        ServletOutputStream outputStream = response.getOutputStream();
        if (StringUtils.isNotBlank((String)fileName)) {
            block5: {
                try {
                    File downloadFile = new File(this.baseDirectory, fileName);
                    response.setContentLength((int)downloadFile.length());
                    inputStream = FileUtils.openInputStream((File)downloadFile);
                    IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
                    outputStream.flush();
                    if (!this.deleteAfterDownload) break block5;
                    downloadFile.delete();
                }
                catch (Exception e) {
                    try {
                        logger.error(e.getMessage(), (Throwable)e);
                        throw new RuntimeException(e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(inputStream);
                        IOUtils.closeQuietly((OutputStream)outputStream);
                        throw throwable;
                    }
                }
            }
            IOUtils.closeQuietly((InputStream)inputStream);
            IOUtils.closeQuietly((OutputStream)outputStream);
        }
    }

    public void destroy() {
    }
}

