/*
 * Decompiled with CFR 0.152.
 */
package org.yestech.lib.jpa;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.yestech.lib.util.CastUtil;

public class EntityManagerAdapter {
    @PersistenceContext
    private EntityManager entityManager;

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public <T> T findById(Class<T> entityClass, Object id) {
        if (null == entityClass) {
            throw new IllegalArgumentException("entityClass can't be null");
        }
        if (null == id) {
            throw new IllegalArgumentException("id can't be null");
        }
        return (T)this.entityManager.find(entityClass, id);
    }

    public boolean delete(Object entity) {
        if (null == entity) {
            throw new IllegalArgumentException("entity can't be null");
        }
        this.entityManager.remove(entity);
        return true;
    }

    public <T> boolean deleteById(Class<T> entityClass, Object id) {
        if (null == entityClass) {
            throw new IllegalArgumentException("entityClass can't be null");
        }
        if (null == id) {
            throw new IllegalArgumentException("id can't be null");
        }
        return this.delete(this.findById(entityClass, id));
    }

    public <T> List<T> getAllEntities(Class<T> entityClass) {
        if (null == entityClass) {
            throw new IllegalArgumentException("entityClass can't be null");
        }
        return CastUtil.cast(this.entityManager.createQuery("select e from " + entityClass.getSimpleName() + " e").getResultList());
    }

    public <T> List<T> getAllEntities(Class<T> entityClass, String orderByAttributeName, SortOrder sortOrder) {
        if (null == entityClass) {
            throw new IllegalArgumentException("entityClass can't be null");
        }
        if (null == orderByAttributeName) {
            throw new IllegalArgumentException("orderByAttributeName can't be null");
        }
        return CastUtil.cast(this.entityManager.createQuery("select e from " + entityClass.getSimpleName() + " e order by e." + orderByAttributeName + " " + sortOrder.name()).getResultList());
    }

    public <T> T persistOrMerge(Class<T> entityClass, T entity) {
        if (null == entityClass) {
            throw new IllegalArgumentException("entityClass can't be null");
        }
        if (null == entity) {
            throw new IllegalArgumentException("entity can't be null");
        }
        if (!this.entityManager.contains(entity)) {
            this.persist(entityClass, entity);
        } else {
            this.merge(entityClass, entity);
        }
        return entity;
    }

    public <T> T persist(Class<T> entityClass, T entity) {
        if (null == entityClass) {
            throw new IllegalArgumentException("entityClass can't be null");
        }
        if (null == entity) {
            throw new IllegalArgumentException("entity can't be null");
        }
        this.entityManager.persist(entity);
        return entity;
    }

    public <T> T merge(Class<T> entityClass, T entity) {
        if (null == entityClass) {
            throw new IllegalArgumentException("entityClass can't be null");
        }
        if (null == entity) {
            throw new IllegalArgumentException("entity can't be null");
        }
        return (T)this.entityManager.merge(entity);
    }

    public long countEntities(Class<?> entityClass) {
        if (null == entityClass) {
            throw new IllegalArgumentException("entityClass can't be null");
        }
        return (Long)this.entityManager.createQuery("select count(entity) from " + entityClass.getSimpleName() + " entity").getSingleResult();
    }

    public long countEntitiesByAttribute(Class<?> entityClass, String attributeName, Object attributeValue) {
        if (null == entityClass) {
            throw new IllegalArgumentException("entityClass can't be null");
        }
        if (null == attributeName) {
            throw new IllegalArgumentException("attributeName can't be null");
        }
        if (null == attributeValue) {
            throw new IllegalArgumentException("attributeValue can't be null");
        }
        return (Long)this.entityManager.createQuery("select count(e) from " + entityClass.getSimpleName() + " e where e." + attributeName + " = ?1").setParameter(1, attributeValue).getSingleResult();
    }

    public static enum SortOrder {
        ASC,
        DESC;

    }
}

