/*
 * Decompiled with CFR 0.152.
 */
package org.yestech.lib.lang;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Set;

public class ArraySet<E>
extends AbstractSet<E>
implements Set<E>,
Cloneable,
Serializable {
    private ArrayList<E> backingList;

    public ArraySet() {
        this(0);
    }

    public ArraySet(int size) {
        this.backingList = new ArrayList(size);
    }

    public ArraySet(Collection c) {
        this(c, 0);
        this.addAll(c);
    }

    public ArraySet(Collection c, int size) {
        this(size);
        this.addAll(c);
    }

    @Override
    public Iterator<E> iterator() {
        return this.backingList.listIterator();
    }

    @Override
    public int size() {
        return this.backingList.size();
    }

    @Override
    public boolean isEmpty() {
        return this.backingList.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.backingList.contains(o);
    }

    @Override
    public boolean add(E o) {
        boolean found = this.contains(o);
        if (!found) {
            this.backingList.add(o);
        }
        return found;
    }

    @Override
    public boolean remove(Object o) {
        boolean found = this.contains(o);
        if (found) {
            this.backingList.remove(o);
        }
        return found;
    }

    @Override
    public void clear() {
        this.backingList.clear();
    }

    public Object clone() {
        try {
            ArraySet newSet = (ArraySet)super.clone();
            newSet.backingList = (ArrayList)this.backingList.clone();
            return newSet;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.backingList.size());
        ListIterator<E> i = this.backingList.listIterator();
        while (i.hasNext()) {
            s.writeObject(i.next());
        }
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int size = s.readInt();
        this.backingList = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            Object e = s.readObject();
            this.backingList.add(e);
        }
    }
}

