/*
 * Decompiled with CFR 0.152.
 */
package org.yestech.lib.lang;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Clazz {
    private static final Logger logger = LoggerFactory.getLogger(Clazz.class);

    private Clazz() {
    }

    public static Class getClass(String classFqn) {
        Class clazz = InMemoryReflectionCache.getClass(classFqn);
        return clazz;
    }

    public static <I> I instantiateClass(String classFQN) {
        return Clazz.instantiateClass(Clazz.getClass(classFQN));
    }

    public static <I> I instantiateClass(Class clazz) {
        try {
            return (I)clazz.newInstance();
        }
        catch (Exception e) {
            logger.error("Error Instantiating Class: " + clazz, (Throwable)e);
            throw new RuntimeException("Error Instantiating Class: " + clazz, e);
        }
    }

    public static Method getMethod(String classFQN, String methodName, Class[] params) {
        return InMemoryReflectionCache.getMethod(classFQN, methodName, params);
    }

    public static Object invoke(Method method, Object[] methodArgs, Object instance) {
        try {
            return method.invoke(instance, methodArgs);
        }
        catch (Exception e) {
            logger.error("Error Invoking Method: " + method.getName(), (Throwable)e);
            throw new RuntimeException("Error Invoking Method: " + method.getName(), e);
        }
    }

    public static Object invoke(String classFQN, String methodName, Class[] params, Object[] methodArgs, Object instance) {
        return Clazz.invoke(Clazz.getMethod(classFQN, methodName, params), methodArgs, instance);
    }

    public static Method getMethod(Class clazz, String methodName, Class[] argTypes) {
        return InMemoryReflectionCache.getMethod(clazz, methodName, argTypes);
    }

    public static Constructor getConstructor(Class clazz, Class[] ctorTypes) {
        return InMemoryReflectionCache.getCtor(clazz, ctorTypes);
    }

    private static class InMemoryReflectionCache
    implements Serializable {
        private static final Logger logger = LoggerFactory.getLogger(InMemoryReflectionCache.class);
        private static final HashMap<String, Class> classCache = new HashMap();
        private static final HashMap<String, ArrayList> methodCache = new HashMap();
        private static final HashMap<String, ArrayList> ctorCache = new HashMap();

        private InMemoryReflectionCache() {
        }

        public static Class getClass(String className) {
            Class<?> clazz = classCache.get(className);
            if (clazz == null) {
                try {
                    clazz = Class.forName(className);
                }
                catch (ClassNotFoundException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    throw new RuntimeException(e);
                }
                classCache.put(className, clazz);
            }
            return clazz;
        }

        public static Method getMethod(String clazzName, String methodName, Class[] argTypes) {
            return InMemoryReflectionCache.getMethod(InMemoryReflectionCache.getClass(clazzName), methodName, argTypes);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Method getMethod(Class clazz, String methodName, Class[] argTypes) {
            int sz;
            Method method = null;
            ArrayList<Method> methods = null;
            methods = methodCache.get(methodName);
            if (methods == null) {
                HashMap<String, ArrayList> hashMap = methodCache;
                synchronized (hashMap) {
                    methods = methodCache.get(methodName);
                    if (methods == null) {
                        methods = new ArrayList<Method>();
                        methodCache.put(methodName, methods);
                    }
                }
            }
            if ((sz = methods.size()) == 0) {
                try {
                    method = clazz.getMethod(methodName, argTypes);
                }
                catch (NoSuchMethodException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    throw new RuntimeException(e);
                }
                ArrayList<Method> e = methods;
                synchronized (e) {
                    if (!methods.contains(method)) {
                        methods.add(method);
                    }
                }
            }
            for (int i = 0; i < sz; ++i) {
                Method tmethod = (Method)methods.get(i);
                Class<?>[] targTypes = tmethod.getParameterTypes();
                if (!(argTypes != null && argTypes.length != 0 || targTypes != null && targTypes.length != 0)) {
                    method = tmethod;
                    continue;
                }
                int tsz = targTypes.length;
                if (argTypes.length != tsz) continue;
                boolean valid = false;
                for (int t = 0; t < tsz; ++t) {
                    boolean good = argTypes[t].isAssignableFrom(targTypes[t]);
                    if (!good) {
                        valid = false;
                        break;
                    }
                    valid = true;
                }
                if (!valid) continue;
                method = tmethod;
            }
            if (method == null) {
                try {
                    method = clazz.getMethod(methodName, argTypes);
                }
                catch (NoSuchMethodException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    throw new RuntimeException(e);
                }
                ArrayList<Method> arrayList = methods;
                synchronized (arrayList) {
                    if (!methods.contains(method)) {
                        methods.add(method);
                    }
                }
            }
            return method;
        }

        public static Constructor getCtor(String clazzName, Class[] ctorTypes) {
            return InMemoryReflectionCache.getCtor(InMemoryReflectionCache.getClass(clazzName), ctorTypes);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Constructor getCtor(Class clazz, Class[] ctorTypes) {
            int sz;
            String ctorName = clazz.getName();
            Constructor ctor = null;
            ArrayList<Constructor> ctors = null;
            ctors = ctorCache.get(ctorName);
            if (ctors == null) {
                HashMap<String, ArrayList> hashMap = ctorCache;
                synchronized (hashMap) {
                    ctors = ctorCache.get(ctorName);
                    if (ctors == null) {
                        ctors = new ArrayList<Constructor>();
                        ctorCache.put(ctorName, ctors);
                    }
                }
            }
            if ((sz = ctors.size()) == 0) {
                try {
                    ctor = clazz.getConstructor(ctorTypes);
                }
                catch (NoSuchMethodException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    throw new RuntimeException(e);
                }
                ArrayList<Constructor> e = ctors;
                synchronized (e) {
                    if (!ctors.contains(ctor)) {
                        ctors.add(ctor);
                    }
                }
            }
            for (int i = 0; i < sz; ++i) {
                Constructor tctor = (Constructor)ctors.get(i);
                Class<?>[] tctorTypes = tctor.getParameterTypes();
                if (!(ctorTypes != null && ctorTypes.length != 0 || tctorTypes != null && tctorTypes.length != 0)) {
                    ctor = tctor;
                    continue;
                }
                int tsz = tctorTypes.length;
                if (ctorTypes.length != tsz) continue;
                boolean valid = false;
                for (int t = 0; t < tsz; ++t) {
                    boolean good = ctorTypes[t].isAssignableFrom(tctorTypes[t]);
                    if (!good) {
                        valid = false;
                        break;
                    }
                    valid = true;
                }
                if (!valid) continue;
                ctor = tctor;
            }
            if (ctor == null) {
                try {
                    ctor = clazz.getConstructor(ctorTypes);
                }
                catch (NoSuchMethodException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    throw new RuntimeException(e);
                }
                ArrayList<Constructor> arrayList = ctors;
                synchronized (arrayList) {
                    if (!ctors.contains(ctor)) {
                        ctors.add(ctor);
                    }
                }
            }
            return ctor;
        }

        public static InMemoryReflectionCache getManager() {
            return new InMemoryReflectionCache();
        }
    }
}

