/*
 * Decompiled with CFR 0.152.
 */
package org.yestech.lib.runtime;

import java.lang.reflect.Method;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Jvm {
    public static final JvmVersion VERSION = new JvmVersion(System.getProperties());

    private Jvm() {
    }

    public static int getMegaVersion() {
        return VERSION.getMegaVersion();
    }

    public static int getMajorVersion() {
        return VERSION.getMajorVersion();
    }

    public static int getMinorVersion() {
        return VERSION.getMinorVersion();
    }

    public static String getPatchLevel() {
        return VERSION.getPatchLevel();
    }

    public static boolean isJDK14() {
        return VERSION.isJDK14();
    }

    public static boolean isJDK15() {
        return VERSION.isJDK15();
    }

    public static boolean isJDK16() {
        return VERSION.isJDK16();
    }

    public static boolean isJDK17() {
        return VERSION.isJDK17();
    }

    public static boolean isJDK15Compliant() {
        return VERSION.getMajorVersion() >= 5;
    }

    public static boolean isJDK16Compliant() {
        return VERSION.getMajorVersion() >= 6;
    }

    public static boolean isIBM() {
        if (VERSION == null) {
            return JvmVersion.thisVMisIBM();
        }
        return VERSION.isIBM();
    }

    public static void assertIsIbm() {
        if (!Jvm.isIBM()) {
            throw new AssertionError((Object)"not ibm");
        }
    }

    public static boolean isJRockit() {
        return VERSION.isJRockit();
    }

    public static boolean isAzul() {
        return VERSION.isAzul();
    }

    private static class JvmVersion {
        private static final Pattern JVM_VERSION_PATTERN = Pattern.compile("^(\\p{Digit})\\.(\\p{Digit})\\.(\\p{Digit})(?:[-_](.+))?$");
        private static final Pattern IBM_SERVICE_RELEASE_PATTERN = Pattern.compile("^[^-]+-\\p{Digit}{8}[^\\p{Space}]*\\p{Space}*\\(.*(SR\\p{Digit}+).*\\)$");
        private final String vmVersion;
        private final int mega;
        private final int major;
        private final int minor;
        private final String patch;
        private final boolean isIBM;
        private final boolean isJRockit;
        private final boolean isAzul;

        public JvmVersion(Properties props) {
            this(JvmVersion.javaVersion(props), JvmVersion.runtimeVersion(props), JvmVersion.isJRockit(props), JvmVersion.isIBM(props), JvmVersion.isAzul(props));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private JvmVersion(String vendorVersion, String runtimeVersion, boolean isJRockit, boolean isIBM, boolean isAzul) {
            String version_patch;
            this.isIBM = isIBM;
            this.isJRockit = isJRockit;
            this.isAzul = isAzul;
            Matcher versionMatcher = JVM_VERSION_PATTERN.matcher(vendorVersion);
            if (!versionMatcher.matches()) throw new RuntimeException(vendorVersion);
            this.mega = Integer.parseInt(versionMatcher.group(1));
            this.major = Integer.parseInt(versionMatcher.group(2));
            this.minor = Integer.parseInt(versionMatcher.group(3));
            String string = version_patch = versionMatcher.groupCount() == 4 ? versionMatcher.group(4) : null;
            if (isIBM) {
                String serviceRelease;
                Matcher serviceReleaseMatcher = IBM_SERVICE_RELEASE_PATTERN.matcher(runtimeVersion);
                if (!serviceReleaseMatcher.matches()) throw new RuntimeException(vendorVersion + " : " + runtimeVersion);
                String string2 = serviceRelease = serviceReleaseMatcher.groupCount() == 1 ? serviceReleaseMatcher.group(1).toLowerCase() : null;
                this.patch = null == version_patch && null == serviceRelease ? null : (null == version_patch ? serviceRelease : (null == serviceRelease ? version_patch : version_patch + serviceRelease));
            } else {
                this.patch = version_patch;
            }
            this.vmVersion = this.mega + "." + this.major + "." + this.minor + (null == this.patch ? "" : "_" + this.patch);
        }

        public int getMegaVersion() {
            return this.mega;
        }

        public int getMajorVersion() {
            return this.major;
        }

        public int getMinorVersion() {
            return this.minor;
        }

        public String getPatchLevel() {
            return this.patch;
        }

        public boolean isJDK14() {
            return this.mega == 1 && this.major == 4;
        }

        public boolean isJDK15() {
            return this.mega == 1 && this.major == 5;
        }

        public boolean isJDK16() {
            return this.mega == 1 && this.major == 6;
        }

        public boolean isJDK17() {
            return this.mega == 1 && this.major == 7;
        }

        public boolean isIBM() {
            return this.isIBM;
        }

        public boolean isAzul() {
            return this.isAzul;
        }

        public boolean isJRockit() {
            return this.isJRockit;
        }

        public boolean equals(Object o) {
            if (!(o instanceof JvmVersion)) {
                return false;
            }
            JvmVersion other = (JvmVersion)o;
            return this.vmVersion.equals(other.vmVersion);
        }

        public int hashCode() {
            return this.vmVersion.hashCode();
        }

        public String toString() {
            return this.vmVersion;
        }

        private static String javaVersion(Properties props) {
            return props.getProperty("java.version", "<error: java.version not specified in properties>");
        }

        private static String runtimeVersion(Properties props) {
            if (JvmVersion.thisVMisIBM()) {
                return JvmVersion.getIBMRuntimeVersion();
            }
            return props.getProperty("java.runtime.version", "<error: java.runtime.version not specified in properties>");
        }

        static boolean thisVMisIBM() {
            return JvmVersion.isIBM(System.getProperties());
        }

        private static String getIBMRuntimeVersion() {
            try {
                Class<?> c = Class.forName("com.ibm.misc.JavaRuntimeVersion");
                Method m = c.getDeclaredMethod("getValue", new Class[0]);
                m.setAccessible(true);
                return (String)m.invoke(c, new Object[0]);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }

        private static boolean isAzul(Properties props) {
            return props.getProperty("java.vendor", "").toLowerCase().indexOf("azul") >= 0;
        }

        private static boolean isIBM(Properties props) {
            return props.getProperty("java.vendor", "").toLowerCase().startsWith("ibm ");
        }

        private static boolean isJRockit(Properties props) {
            return props.getProperty("jrockit.version") != null || props.getProperty("java.vm.name", "").toLowerCase().indexOf("jrockit") >= 0;
        }
    }
}

