/*
 * Decompiled with CFR 0.152.
 */
package org.yestech.lib.spring;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Required;
import org.terracotta.message.pipe.BlockingQueueBasedPipe;
import org.terracotta.message.pipe.Pipe;
import org.terracotta.message.routing.Router;
import org.terracotta.message.topology.DefaultTopology;
import org.terracotta.message.topology.Topology;
import org.terracotta.message.topology.TopologyManager;
import org.terracotta.modules.annotations.Root;

public class TerracottaPipeFactoryBean
implements FactoryBean,
InitializingBean {
    @Root
    private Pipe pipe;
    private Router router;
    private String topologyName;
    private String pipeName;
    private int pipeSize = 1000;

    public Object getObject() throws Exception {
        return this.pipe;
    }

    public Class getObjectType() {
        return this.pipe != null ? this.pipe.getClass() : Pipe.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public Router getRouter() {
        return this.router;
    }

    public void setRouter(Router router) {
        this.router = router;
    }

    public String getTopologyName() {
        return this.topologyName;
    }

    public String getPipeName() {
        return this.pipeName;
    }

    public void setPipeName(String pipeName) {
        this.pipeName = pipeName;
    }

    @Required
    public void setTopologyName(String topologyName) {
        this.topologyName = topologyName;
    }

    public int getPipeSize() {
        return this.pipeSize;
    }

    public void setPipeSize(int pipeSize) {
        this.pipeSize = pipeSize;
    }

    public void afterPropertiesSet() throws Exception {
        System.out.println("TerracottaPipeFactoryBean pipeSize : " + this.pipeSize);
        BlockingQueueBasedPipe.Factory pipeFactory = new BlockingQueueBasedPipe.Factory(this.pipeSize);
        DefaultTopology.Factory topologyFactory = new DefaultTopology.Factory((Pipe.Factory)pipeFactory);
        System.out.println("TerracottaPipeFactoryBean topologyName : " + this.topologyName);
        Topology topology = TopologyManager.getInstance().getOrCreateTopology(this.topologyName, (Topology.Factory)topologyFactory);
        this.pipe = StringUtils.isNotBlank((String)this.pipeName) ? topology.getOrCreatePipeFor((Object)this.pipeName) : topology.getOrCreatePipeFor((Object)this.topologyName);
        System.out.println("TerracottaPipeFactoryBean pipe : " + this.pipe);
    }
}

