/*
 * Decompiled with CFR 0.152.
 */
package org.yestech.lib.spring.property;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.web.context.support.ServletContextPropertyPlaceholderConfigurer;
import org.yestech.lib.spring.property.Property;

public class PropertyAnnotationAndPlaceholderConfigurer
extends ServletContextPropertyPlaceholderConfigurer {
    private static Logger log = LoggerFactory.getLogger(PropertyAnnotationAndPlaceholderConfigurer.class);

    protected void processProperties(ConfigurableListableBeanFactory beanFactory, Properties properties) throws BeansException {
        super.processProperties(beanFactory, properties);
        for (String name : beanFactory.getBeanDefinitionNames()) {
            MutablePropertyValues mpv = beanFactory.getBeanDefinition(name).getPropertyValues();
            Class clazz = beanFactory.getType(name);
            if (log.isDebugEnabled()) {
                log.debug("Configuring properties for bean=" + name + "[" + clazz + "]");
            }
            if (clazz == null) continue;
            for (PropertyDescriptor property : BeanUtils.getPropertyDescriptors((Class)clazz)) {
                Method setter = property.getWriteMethod();
                Method getter = property.getReadMethod();
                Property annotation = null;
                if (setter != null && setter.isAnnotationPresent(Property.class)) {
                    annotation = setter.getAnnotation(Property.class);
                } else if (setter != null && getter != null && getter.isAnnotationPresent(Property.class)) {
                    annotation = getter.getAnnotation(Property.class);
                }
                if (annotation == null) continue;
                String value = this.resolvePlaceholder(annotation.key(), properties, 1);
                if (StringUtils.isEmpty((String)value)) {
                    value = annotation.defaultValue();
                }
                if (StringUtils.isEmpty((String)value)) {
                    throw new BeanCreationException("No such property=[" + annotation.key() + "] found in properties.");
                }
                if (log.isDebugEnabled()) {
                    log.debug("setting property=[" + clazz.getName() + "." + property.getName() + "] value=[" + annotation.key() + "=" + value + "]");
                }
                mpv.addPropertyValue(property.getName(), (Object)value);
            }
            for (Field field : clazz.getDeclaredFields()) {
                if (log.isDebugEnabled()) {
                    log.debug("examining field=[" + clazz.getName() + "." + field.getName() + "]");
                }
                if (!field.isAnnotationPresent(Property.class)) continue;
                Property annotation = field.getAnnotation(Property.class);
                PropertyDescriptor property = BeanUtils.getPropertyDescriptor((Class)clazz, (String)field.getName());
                if (property.getWriteMethod() == null) {
                    throw new BeanCreationException("setter for property=[" + clazz.getName() + "." + field.getName() + "] not available.");
                }
                String value = this.resolvePlaceholder(annotation.key(), properties, 1);
                if (value == null) {
                    value = annotation.defaultValue();
                }
                if (value == null) {
                    throw new BeanCreationException("No such property=[" + annotation.key() + "] found in properties.");
                }
                if (log.isDebugEnabled()) {
                    log.debug("setting property=[" + clazz.getName() + "." + field.getName() + "] value=[" + annotation.key() + "=" + value + "]");
                }
                mpv.addPropertyValue(property.getName(), (Object)value);
            }
        }
    }
}

