/*
 * Decompiled with CFR 0.152.
 */
package org.yestech.lib.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DecoderUtil {
    private static final Logger logger = LoggerFactory.getLogger(DecoderUtil.class);
    private static final String DEFAULT_STRING_ENCODING = "UTF-8";

    private DecoderUtil() {
    }

    public static String urlDecode(String value) {
        return DecoderUtil.urlDecode(value, DEFAULT_STRING_ENCODING);
    }

    public static String urlDecode(String value, String encoding) {
        try {
            if (value == null) {
                return "";
            }
            if (StringUtils.isBlank((String)value)) {
                return value;
            }
            return URLDecoder.decode(value, encoding);
        }
        catch (UnsupportedEncodingException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String htmlDecode(String s) {
        return StringEscapeUtils.unescapeHtml((String)s);
    }

    public static String uriDecode(String encodedStr) {
        if (encodedStr == null) {
            return null;
        }
        if (encodedStr.indexOf(37) < 0) {
            return encodedStr;
        }
        StringBuffer buffer = new StringBuffer(encodedStr);
        DecoderUtil.uriDecode(buffer, 0, buffer.length());
        return buffer.toString();
    }

    private static void uriDecode(StringBuffer buffer, int offset, int length) {
        int index = offset;
        int count = length;
        while (count > 0) {
            char ch = buffer.charAt(index);
            if (ch == '%') {
                if (count < 3) {
                    throw new RuntimeException("invalid-escape-sequence.error: " + buffer.substring(index, index + count));
                }
                int dig1 = Character.digit(buffer.charAt(index + 1), 16);
                int dig2 = Character.digit(buffer.charAt(index + 2), 16);
                if (dig1 == -1 || dig2 == -1) {
                    throw new RuntimeException("invalid-escape-sequence.error " + buffer.substring(index, index + 3));
                }
                char value = (char)(dig1 << 4 | dig2);
                buffer.setCharAt(index, value);
                buffer.delete(index + 1, index + 3);
                count -= 2;
            }
            --count;
            ++index;
        }
    }

    public static String xmlDecode(String s) {
        return StringEscapeUtils.unescapeXml((String)s);
    }
}

